/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.loadbalance;

import com.kingdee.bos.orm.loadbalance.DispatchPolicy;
import com.kingdee.bos.orm.loadbalance.RpcServer;
import java.util.Arrays;
import java.util.Comparator;

public class SimplePolicy
implements DispatchPolicy {
    public static final String CAPABILITY = "capability";
    public static final float DEFAULT_CAPABILITY = 1.0f;
    public static final long RETRY_TIME = 30000L;
    private RpcServer[] servers;

    public static float getCapability(RpcServer server) {
        Number c = (Number)server.getProperty(CAPABILITY);
        if (c == null || c.floatValue() == 0.0f) {
            return 1.0f;
        }
        return c.floatValue();
    }

    @Override
    public void initRpcServers(RpcServer[] _servers) {
        this.servers = _servers;
    }

    @Override
    public synchronized RpcServer[] getRpcServers() {
        RpcServer[] ss = new RpcServer[this.servers.length];
        System.arraycopy(this.servers, 0, ss, 0, ss.length);
        Arrays.sort(ss, new _Comp());
        if (ss.length > 0) {
            ss[0].setState(1);
        }
        return ss;
    }

    private static class _Comp
    implements Comparator {
        private _Comp() {
        }

        public int compare(Object a, Object b) {
            float cn2;
            float c2;
            float f2;
            float cn1;
            RpcServer s1 = (RpcServer)a;
            RpcServer s2 = (RpcServer)b;
            int state1 = s1.getState();
            int state2 = s2.getState();
            if (state1 == 2 && System.currentTimeMillis() - s1.getStateUpdateTime() >= 30000L) {
                state1 = 0;
            }
            if (state2 == 2 && System.currentTimeMillis() - s2.getStateUpdateTime() >= 30000L) {
                state2 = 0;
            }
            if (state1 != state2) {
                if (state1 > state2) {
                    return 1;
                }
                return -1;
            }
            float c1 = SimplePolicy.getCapability(s1);
            float f1 = c1 / ((cn1 = (float)s1.perf.getConnectionCount()) + 1.0f);
            if (f1 > (f2 = (c2 = SimplePolicy.getCapability(s2)) / ((cn2 = (float)s2.perf.getConnectionCount()) + 1.0f))) {
                return -1;
            }
            if (f1 < f2) {
                return 1;
            }
            if (cn1 < cn2) {
                return -1;
            }
            if (cn1 > cn2) {
                return 1;
            }
            return 0;
        }
    }
}

