/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.loadbalance;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.io.StreamConnectionHelper;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.loadbalance.LoadBalanceConnectionDriver;
import com.kingdee.bos.util.EasyTool;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPLoadBalanceServer
extends Thread {
    final ServerSocket svr;

    public TCPLoadBalanceServer(ServerSocket _svr) {
        TCPLoadBalanceServer.loadConfig();
        this.svr = _svr;
    }

    public TCPLoadBalanceServer(int _port) throws IOException {
        TCPLoadBalanceServer.loadConfig();
        this.svr = new ServerSocket(_port);
    }

    public TCPLoadBalanceServer() throws IOException {
        this(11034);
    }

    private static void loadConfig() {
        ORMRPConfig.loadConfig();
        if (ORMRPConfig.isBalanceMode()) {
            LoadBalanceConnectionDriver loadDriver = LoadBalanceConnectionDriver.newDriver(ORMRPConfig.getBalanceServers());
            ORMEngine.connectionManager.registerDriver(loadDriver);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket sock = this.svr.accept();
                new _Connection(sock).start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    public void shutdown() {
        try {
            this.svr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class _ConnectionPipe
    extends Thread {
        IConnectionHelper in;
        IConnectionHelper out;

        _ConnectionPipe(IConnectionHelper _in, IConnectionHelper _out) {
            this.in = _in;
            this.out = _out;
        }

        @Override
        public void run() {
            try {
                byte[] b;
                while ((b = this.in.recvBlock()) != null) {
                    this.out.sendBlock(b, 0, b.length);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.in.close();
                this.out.close();
            }
        }
    }

    private static class _Connection
    extends Thread {
        Socket sock;

        _Connection(Socket _sock) {
            this.sock = _sock;
        }

        @Override
        public void run() {
            try {
                IConnectionHelper helper = ORMEngine.connectionManager.directConnect("loadbalance", null);
                StreamConnectionHelper helper2 = new StreamConnectionHelper(this.sock);
                new _ConnectionPipe(helper2, helper).start();
                new _ConnectionPipe(helper, helper2).run();
            }
            catch (Throwable e) {
                e.printStackTrace();
                EasyTool.closeAny((Object)this.sock);
            }
        }
    }
}

