/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.util;

import com.kingdee.bos.orm.util.JavaGenerator;
import java.io.File;
import java.io.FileInputStream;
import org.apache.log4j.Logger;

public class DynamicClassLoader
extends ClassLoader {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.util.DynamicClassLoader");
    ClassLoader parent = this.getClass().getClassLoader();
    ClassLoader parent2;

    public DynamicClassLoader() {
        this(null);
    }

    public DynamicClassLoader(ClassLoader classLoader) {
        if (classLoader != null && this.parent != null && !this.parent.equals(classLoader)) {
            this.parent2 = classLoader;
        }
    }

    public Class loadClassFromFile(String className, File classFile, Class digestModel) {
        try {
            String digest = JavaGenerator.getModelDigest(digestModel);
            Class cls = this.loadClassFromFile(className, classFile);
            if (cls == null) {
                return null;
            }
            String digest1 = JavaGenerator.getClassDigest(cls);
            if (digest1 == null || digest1.equals(digest)) {
                return cls;
            }
            return null;
        }
        catch (Throwable _) {
            logger.error((Object)_);
            return null;
        }
    }

    public Class loadClassFromData(String className, byte[] data) throws ClassNotFoundException {
        Class<?> cls = this.defineClass(className, data, 0, data.length);
        this.resolveClass(cls);
        return cls;
    }

    public Class loadClassFromFile(String className, File f) {
        try {
            int r;
            int len;
            if (!f.exists()) {
                return null;
            }
            byte[] data = new byte[len];
            int i = 0;
            FileInputStream fin = new FileInputStream(f);
            for (len = (int)f.length(); len > 0 && (r = fin.read(data, i, len)) > 0; len -= r) {
                i += r;
            }
            fin.close();
            Class<?> cls = this.defineClass(null, data, 0, data.length);
            this.resolveClass(cls);
            return cls;
        }
        catch (Throwable _) {
            _.printStackTrace();
            return null;
        }
    }

    protected Class loadClass(String name, boolean resolved) throws ClassNotFoundException {
        Class cls = this.loadClass0(name);
        if (resolved) {
            this.resolveClass(cls);
        }
        return cls;
    }

    private Class loadClass0(String name) throws ClassNotFoundException {
        if (this.parent != null) {
            try {
                return this.parent.loadClass(name);
            }
            catch (Exception _) {
                // empty catch block
            }
        }
        if (this.parent2 != null) {
            try {
                return this.parent2.loadClass(name);
            }
            catch (Exception _) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name);
        }
        catch (Exception exception) {
            return Class.forName(name);
        }
    }
}

