/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.util;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.util.EasyTool;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.javac.Main;

public class JavaGenerator {
    public static final String VERSION = "1.0.0";
    public final String packageName;
    public final String className;
    public final String superClass;
    Hashtable imports = new Hashtable();
    Vector interfaces = new Vector();
    public static final String tab = "    ";
    ByteArrayOutputStream bodyOut;
    public final PrintWriter out;
    Comparator stringComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareTo((String)o2);
        }
    };
    public static final File DEFAULT_ROOT = new File("temporary");
    public static final File DEFAULT_SOURCE_ROOT = new File(DEFAULT_ROOT, "src");
    public static final File DEFAULT_CLASS_ROOT = new File(DEFAULT_ROOT, "classes");
    public static final String compileClassPath = null;
    public static final Method queryInterfaceMethod;
    public static final String DIGEST_FIELD = "_modelDigest";

    public JavaGenerator(String _packageName, String _className) {
        this(_packageName, _className, null);
    }

    public JavaGenerator(String _packageName, String _className, String _superClass) {
        this.packageName = _packageName;
        this.className = _className;
        this.superClass = _superClass;
        this.bodyOut = new ByteArrayOutputStream();
        this.out = new PrintWriter(this.bodyOut);
    }

    public void registerImport(String imp) {
        this.imports.put(imp, imp);
    }

    public void registerImport(Class cls) {
        if (!(cls == null || cls.isPrimitive() || cls.getPackage() != null && cls.getPackage().getName().equals("java.lang"))) {
            this.registerImport(cls.getName());
        }
    }

    public void registerImport(Package pack) {
        if (pack != null && !pack.getName().equals("java.lang")) {
            this.registerImport(pack.getName() + ".*");
        }
    }

    public void addImplements(Class model) {
        this.addImplements(this.getTypeName(model));
    }

    public void addImplements(String interfaceName) {
        this.interfaces.addElement(interfaceName);
    }

    private static boolean isNullString(String s) {
        return s == null || s.length() == 0;
    }

    public void writeStream(OutputStream _out) throws IOException {
        String line;
        int i;
        this.out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.bodyOut.toByteArray())));
        PrintWriter out = new PrintWriter(_out);
        out.println("/*This file is auto generate by JavaGenerator.*/");
        if (!JavaGenerator.isNullString(this.packageName)) {
            out.println("package " + this.packageName + ";");
        }
        String[] ips = new String[this.imports.size()];
        Enumeration e = this.imports.elements();
        int ii = 0;
        while (e.hasMoreElements()) {
            ips[ii++] = (String)e.nextElement();
        }
        Arrays.sort(ips, this.stringComparator);
        for (i = 0; i < ips.length; ++i) {
            out.println("import " + ips[i] + ";");
        }
        out.println();
        out.print("public class " + this.className);
        if (!JavaGenerator.isNullString(this.superClass)) {
            out.println(" extends " + this.superClass);
        } else {
            out.println();
        }
        if (this.interfaces.size() > 0) {
            out.print("    implements ");
            for (i = 0; i < this.interfaces.size(); ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print((String)this.interfaces.elementAt(i));
            }
            out.println();
        }
        out.println("{");
        while ((line = in.readLine()) != null) {
            out.println(tab + JavaGenerator.replace(line, "\t", tab));
        }
        out.println("}");
        out.flush();
    }

    private static String replace(String source, String match, String with) {
        int index = source.indexOf(match);
        if (index < 0) {
            return source;
        }
        return source.substring(0, index) + with + JavaGenerator.replace(source.substring(index + match.length()), match, with);
    }

    public void writeFile(File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        this.writeStream(fout);
        fout.close();
    }

    public void writeFile(String filename) throws IOException {
        FileOutputStream fout = new FileOutputStream(filename);
        this.writeStream(fout);
        fout.close();
    }

    public String getTypeName(Class cls) {
        if (cls.isArray()) {
            return this.getTypeName(cls.getComponentType()) + "[]";
        }
        this.registerImport(cls);
        String name = cls.getName();
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    public File compile() throws Exception {
        return this.compile(System.out);
    }

    public File compile(OutputStream out) throws Exception {
        return this.compile(out, DEFAULT_SOURCE_ROOT, DEFAULT_CLASS_ROOT);
    }

    public static File getClassFile(File root, String className, String packageName) {
        String packagePath = "";
        if (packageName != null && packageName.length() > 0) {
            packagePath = packageName.replace('.', '/') + "/";
        }
        return new File(root, packagePath + className + ".class");
    }

    public File getDefaultSourceFile() {
        String packagePath = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            packagePath = this.packageName.replace('.', '/') + "/";
        }
        File sourcePath = new File(DEFAULT_SOURCE_ROOT, packagePath + this.className + ".java");
        return sourcePath;
    }

    public File getDefaultClassFile() {
        String packagePath = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            packagePath = this.packageName.replace('.', '/') + "/";
        }
        File classPath = new File(DEFAULT_CLASS_ROOT, packagePath + this.className + ".class");
        return classPath;
    }

    public File compile(OutputStream out, File sourceRoot, File classRoot) throws Exception {
        System.out.println("compile for " + this.className);
        String packagePath = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            packagePath = this.packageName.replace('.', '/') + "/";
        }
        File sourcePath = new File(sourceRoot, packagePath + this.className + ".java");
        JavaGenerator.mkdirs(sourcePath.getParentFile());
        JavaGenerator.mkdirs(classRoot);
        String classpath = System.getProperty("java.class.path");
        classpath = classpath == null || classpath.length() == 0 ? ".;" : ".;" + classpath;
        if (compileClassPath != null && compileClassPath.length() > 0) {
            classpath = compileClassPath.endsWith(";") ? compileClassPath + classpath : compileClassPath + ";" + classpath;
        }
        String[] args = new String[]{"-classpath", classpath, "-d", classRoot.getAbsolutePath(), sourcePath.getAbsolutePath()};
        this.writeFile(sourcePath);
        if (!new Main(out, this.getClass().getName()).compile(args)) {
            throw new Exception(sourcePath.getAbsolutePath() + " compile failed.");
        }
        File classPath = new File(classRoot, packagePath + this.className + ".class");
        if (!classPath.exists()) {
            throw new FileNotFoundException(classPath.getAbsolutePath());
        }
        return classPath;
    }

    private static void mkdirs(File path) {
        try {
            path.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void genMethodDeclare(Method md) throws Exception {
        Class<?> type = md.getReturnType();
        String typeName = this.getTypeName(type);
        this.out.print("public " + typeName + " " + md.getName() + "(");
        Class<?>[] args = md.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.out.print(", ");
            }
            this.out.print(this.getTypeName(args[i]) + " p" + i);
        }
        this.out.print(")");
        Class<?>[] exs = md.getExceptionTypes();
        if (exs.length > 0) {
            this.out.print(" throws ");
            for (int i = 0; i < exs.length; ++i) {
                if (i > 0) {
                    this.out.print(", ");
                }
                this.out.print(this.getTypeName(exs[i]));
            }
        }
    }

    public static Class getComponentType(Class cls) {
        if (cls.isArray()) {
            return JavaGenerator.getComponentType(cls.getComponentType());
        }
        return cls;
    }

    public static String getArrayDims(Class type) {
        if (type.isArray()) {
            return JavaGenerator.getArrayDims(type.getComponentType()) + "[]";
        }
        return "";
    }

    public static boolean isInterface(Class model, Class base) {
        if (model.equals(base)) {
            return true;
        }
        Class<?>[] impls = model.getInterfaces();
        for (int i = 0; i < impls.length; ++i) {
            if (!JavaGenerator.isInterface(impls[i], base)) continue;
            return true;
        }
        return false;
    }

    public static boolean isORMModel(Class model) {
        return JavaGenerator.isInterface(model, IORMModel.class);
    }

    public static boolean isInterfaceType(Class type) {
        if (type.isArray()) {
            return JavaGenerator.isInterfaceType(type.getComponentType());
        }
        return type.isInterface();
    }

    public static String getSig(Class type) {
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        if (!type.isPrimitive()) {
            return "L" + type.getName().replace('.', '/') + ";";
        }
        if (type.equals(Boolean.TYPE)) {
            return "Z";
        }
        if (type.equals(Character.TYPE)) {
            return "C";
        }
        if (type.equals(Byte.TYPE)) {
            return "B";
        }
        if (type.equals(Short.TYPE)) {
            return "S";
        }
        if (type.equals(Integer.TYPE)) {
            return "I";
        }
        if (type.equals(Long.TYPE)) {
            return "J";
        }
        if (type.equals(Float.TYPE)) {
            return "F";
        }
        if (type.equals(Double.TYPE)) {
            return "D";
        }
        return "V";
    }

    public static String getMethodSig(Method md) {
        StringBuffer sb = new StringBuffer();
        sb.append(md.getName());
        sb.append("(");
        Class<?>[] args = md.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            sb.append(JavaGenerator.getSig(args[i]));
        }
        sb.append(")");
        sb.append(JavaGenerator.getSig(md.getReturnType()));
        return sb.toString();
    }

    public static String getModelDigest(Class model) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(VERSION);
        sb.append(" ");
        sb.append(model.getName());
        Method[] mds = model.getMethods();
        String[] sigs = new String[mds.length];
        for (i = 0; i < mds.length; ++i) {
            sigs[i] = JavaGenerator.getMethodSig(mds[i]);
        }
        EasyTool.sort((String[])sigs);
        for (i = 0; i < sigs.length; ++i) {
            sb.append(" ");
            sb.append(sigs[i]);
        }
        return sb.toString();
    }

    public void genModelDigest(Class model) throws Exception {
        this.out.println("public static final String _modelDigest=\"" + JavaGenerator.getModelDigest(model) + "\";");
    }

    public static String getClassDigest(Class cls) {
        try {
            return (String)cls.getField(DIGEST_FIELD).get(null);
        }
        catch (Exception _) {
            return null;
        }
    }

    public static String getDefaultValue(Class type) {
        if (!type.isPrimitive()) {
            return "null";
        }
        if (type.equals(Boolean.TYPE)) {
            return "false";
        }
        return "0";
    }

    static {
        Method md = null;
        try {
            Class[] types = new Class[]{Class.class};
            md = IORMModel.class.getMethod("queryInterface", types);
        }
        catch (Exception exception) {
            // empty catch block
        }
        queryInterfaceMethod = md;
    }
}

