/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.ObjectMarshaler;
import com.kingdee.bos.rpc.PingInvoker;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.io.ConnectionMonitor;
import com.kingdee.bos.rpc.performance.InvokeListener;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class RPCConfig {
    private static final Logger logger = Logger.getLogger(RPCConfig.class);
    public ObjectMarshaler objectMarshaler = null;
    public String defaultSSLSecurityProivder;
    public String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    public String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    public String sslProtocol = "SSLv3";
    public boolean dumpInputStream = false;
    public int socketPoolSize = 0;
    public int exceedPoolSocketTimeout = 3000;
    public int defaultSocketTimeout = 60000;
    public long pooledSocketTestIntervalTime = 30000L;
    public int generaterType = 2;
    public String tempDir = new File("temporary").getAbsoluteFile().toString();
    public boolean generateProxyStubSource = false;
    public boolean saveProxyStubClass = false;
    public int streamBufferSize = 16384;
    public int blockBufferSize = 16384;
    public int bufferedOutSize = 1300;
    public int sendBufferSize = -1;
    public int receiveBufferSize = -1;
    public int trafficClass = -1;
    public int pp_connectionTime = -1;
    public int pp_latency = -1;
    public int pp_bandwidth = -1;
    public boolean tcpNoDelay = true;
    public int threadPoolMinSize = 10;
    public int threadPoolMaxSize = 200;
    public long threadPoolIdleTimeout = 10000L;
    public int maxServiceThreadCount = 60;
    public int minServiceThreadCount = 2;
    public boolean logIOExceptions = false;
    public String defaultHttpUrl = "internal";
    public Properties defaultHttpProps = null;
    public int connectionRetryTime = 1;
    public int maxStubReleaseSize = 100;
    public long releaseDelayInterval = 100L;
    public int maxInvokeDataSize = 0x3200000;
    public int maxCompressedDataSize = 0x3200000;
    public int minCompressSize = 1024;
    public boolean compressOnlyRemote = false;
    public boolean logObjectCreate = false;
    public boolean logObjectRelease = false;
    public boolean logObjectFinalize = false;
    public boolean logSessionCreate = false;
    public boolean logSessionClose = false;
    public boolean logSessionTimeout = true;
    public boolean logSessionFinalize = false;
    public boolean logSessionKeepAlive = false;
    public long monitorIntervalTime = 5000L;
    public long sessionTimeout = 600000L;
    public long sessionKeepAliveInterval = 150000L;
    public long httpConnectionTimeout = 600000L;
    public int tcpHandshakeTimeout = 60000;
    public int sslHandshakeTimeout = 60000;
    public int tcpServiceTimeout = 90000;
    public int tcpClientTimeout = 0;
    public long nioSelectTimeout = 5000L;
    public long nioWaitTimeout = 10000L;
    public int nioMaxConnectionsPerSelector = 50;
    public long loadbalanceConnectionRetryTime = 30000L;
    public static InvokeMonitor[] invokeMonitors = new InvokeMonitor[0];
    public static InvokeIntercepter[] invokeIntercepters = new InvokeIntercepter[0];
    public PingInvoker pingInvoker = null;
    public ConnectionMonitor connectionMonitor = null;
    public boolean useConnectionPool = false;
    public long minConnectionInterval = 0L;
    public int lbMonPort = 10034;
    public boolean dynamicFactor = true;
    public IHealthDegree healthDegree;
    public boolean standby;
    public int tcpConnectionPort = 11034;
    public boolean supportSSL = false;
    public int sslConnectionPort = 11033;
    public boolean socketKeepAlive = false;
    public boolean testSocketBeforeUse = false;
    public long normalResponseTime = 100L;
    public Boolean reuseAddress = null;
    public static InvokeListener[] invokeListeners = new InvokeListener[0];
    public boolean monitorCopyStream = false;
    public int socketConnectTimeout = 5000;

    public int getMaxDataSize(boolean compressed) {
        return compressed ? this.maxCompressedDataSize : this.maxInvokeDataSize;
    }

    public RPCConfig copy() {
        RPCConfig conf = new RPCConfig();
        try {
            Field[] fds = RPCConfig.class.getFields();
            for (int i = 0; i < fds.length; ++i) {
                fds[i].set(conf, fds[i].get(this));
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        return conf;
    }

    public static void addInvokeMonitor(InvokeMonitor ivm) {
        if (ivm != null) {
            for (int i = 0; i < invokeMonitors.length; ++i) {
                if (invokeMonitors[i] != ivm) continue;
                return;
            }
            InvokeMonitor[] ivms = new InvokeMonitor[invokeMonitors.length + 1];
            System.arraycopy(invokeMonitors, 0, ivms, 0, invokeMonitors.length);
            ivms[RPCConfig.invokeMonitors.length] = ivm;
            invokeMonitors = ivms;
        }
    }

    public static void removeInvokeMonitor(InvokeMonitor ivm) {
        if (ivm != null) {
            for (int i = 0; i < invokeMonitors.length; ++i) {
                int numMoved;
                if (invokeMonitors[i] != ivm) continue;
                InvokeMonitor[] ivms = new InvokeMonitor[invokeMonitors.length - 1];
                if (i > 0) {
                    System.arraycopy(invokeMonitors, 0, ivms, 0, i);
                }
                if ((numMoved = invokeMonitors.length - i - 1) > 0) {
                    System.arraycopy(invokeMonitors, i + 1, ivms, i, numMoved);
                }
                invokeMonitors = ivms;
                return;
            }
        }
    }

    public static void addInvokeIntercepter(InvokeIntercepter ivi) {
        if (ivi != null) {
            for (int i = 0; i < invokeIntercepters.length; ++i) {
                if (invokeIntercepters[i] != ivi) continue;
                return;
            }
            InvokeIntercepter[] ivis = new InvokeIntercepter[invokeIntercepters.length + 1];
            System.arraycopy(invokeIntercepters, 0, ivis, 0, invokeIntercepters.length);
            ivis[RPCConfig.invokeIntercepters.length] = ivi;
            invokeIntercepters = ivis;
        }
    }

    public static void removeInvokeIntercepter(InvokeIntercepter ivi) {
        if (ivi != null) {
            for (int i = 0; i < invokeIntercepters.length; ++i) {
                int numMoved;
                if (invokeIntercepters[i] != ivi) continue;
                InvokeIntercepter[] ivis = new InvokeIntercepter[invokeIntercepters.length - 1];
                if (i > 0) {
                    System.arraycopy(invokeIntercepters, 0, ivis, 0, i);
                }
                if ((numMoved = invokeIntercepters.length - i - 1) > 0) {
                    System.arraycopy(invokeIntercepters, i + 1, ivis, i, numMoved);
                }
                invokeIntercepters = ivis;
                return;
            }
        }
    }

    public static void addInvokeListener(InvokeListener listener) {
        if (listener != null) {
            for (int i = 0; i < invokeListeners.length; ++i) {
                if (invokeListeners[i] != listener) continue;
                return;
            }
            InvokeListener[] ivms = new InvokeListener[invokeListeners.length + 1];
            System.arraycopy(invokeListeners, 0, ivms, 0, invokeListeners.length);
            ivms[RPCConfig.invokeListeners.length] = listener;
            invokeListeners = ivms;
        }
    }

    public static void removeInvokeListener(InvokeListener listener) {
        if (listener != null) {
            for (int i = 0; i < invokeListeners.length; ++i) {
                int numMoved;
                if (invokeListeners[i] != listener) continue;
                InvokeListener[] ivms = new InvokeListener[invokeListeners.length - 1];
                if (i > 0) {
                    System.arraycopy(invokeListeners, 0, ivms, 0, i);
                }
                if ((numMoved = invokeListeners.length - i - 1) > 0) {
                    System.arraycopy(invokeListeners, i + 1, ivms, i, numMoved);
                }
                invokeListeners = ivms;
                return;
            }
        }
    }
}

