/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.ObjectFactory;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCModel;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;

public class RPCProxySpec {
    public final Class classRPCModel;
    public final Class classIORMModel;
    private HashMap proxyTypes = new HashMap();
    private HashSet proxyModels = new HashSet();

    public RPCProxySpec() {
        try {
            this.classRPCModel = RPCModel.class;
            this.classIORMModel = RPCProxySpec.classForName("com.kingdee.bos.orm.IORMModel");
            if (this.classIORMModel != null) {
                this.registerMethodProxyType(this.classIORMModel.getMethod("queryInterface", Class.class), 0);
            }
            this.registerCreateObjectMethods();
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    private void registerCreateObjectMethods() {
        this.registerCreateObjectMethods(ObjectFactory.class);
        this.registerCreateObjectMethods(RPCProxySpec.classForName("com.kingdee.bos.orm.IObjectFactory"));
    }

    private void registerCreateObjectMethods(Class cls) {
        if (cls == null) {
            return;
        }
        Method[] mds = cls.getMethods();
        for (int i = 0; i < mds.length; ++i) {
            Class<?>[] args;
            if (!mds[i].getName().equals("createObject") || (args = mds[i].getParameterTypes()).length < 2 || !args[0].equals(String.class) || !args[1].equals(Class.class)) continue;
            this.registerMethodProxyType(mds[i], 0);
        }
    }

    protected static Class classForName(String name) {
        try {
            return RPCEngine.loadClass(name);
        }
        catch (Throwable _) {
            return null;
        }
    }

    public void registerMethodProxyType(Method md, Object type) {
        this.proxyTypes.put(md, type);
    }

    public void registerProxyModel(Class model) {
        this.proxyModels.add(model);
    }

    public Object getMethodProxyType(Method md) {
        Object proxyType = this.proxyTypes.get(md);
        if (proxyType != null) {
            return proxyType;
        }
        Class<?> type = md.getReturnType();
        while (type.isArray()) {
            type = type.getComponentType();
        }
        if (this.proxyModels.contains(type)) {
            return md.getReturnType();
        }
        if (type.isInterface()) {
            if (this.classIORMModel != null && this.classIORMModel.isAssignableFrom(type)) {
                return md.getReturnType();
            }
            if (this.classRPCModel.isAssignableFrom(type)) {
                return md.getReturnType();
            }
        }
        if (type.equals(Object.class)) {
            return md.getReturnType();
        }
        return null;
    }
}

