/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.impl.ThreadContext;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class RPCServerSession
extends ContainerBase {
    private static final Logger logger = Logger.getLogger(RPCServerSession.class);
    public final long sessionId = RPCEngine.nextSequenceId();
    private String clientIp;
    private String serverIp;
    private Date createTime;
    private static final ThreadContext threadSessions = new ThreadContext();

    public RPCServerSession(String clientIp) {
        this.clientIp = clientIp;
        this.createTime = new Date();
    }

    public RPCServerSession() {
        this(null);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    protected void validate() {
        if (this.isClosed()) {
            throw new RPCException(1001, "Session#" + this.sessionId + " closed.");
        }
    }

    public static RPCServerSession setCurrentSession(RPCServerSession session) {
        return (RPCServerSession)threadSessions.set(session);
    }

    public static RPCServerSession getCurrentSession() {
        return (RPCServerSession)threadSessions.get();
    }

    public String toString() {
        return "RPCServerSession#" + this.sessionId + " createTime: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(this.createTime) + " clientIp: " + this.clientIp;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (ServerManager.getConfig().logSessionFinalize) {
            logger.info((Object)("ServerSession#" + this.getSessionId() + " finalized."));
        }
        this.close();
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }
}

