/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.ObjectStub;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RPCUtil {
    public static final String SESSIONID = "bos_sessionid";
    private static Logger logger = Logger.getLogger(RPCUtil.class);
    private static String clientIp;

    public static String getClientIp() {
        return clientIp;
    }

    public static void setClientIp(String ip) {
        clientIp = ip;
    }

    public static long toMs(String time) {
        String low = time.toLowerCase();
        if (low.endsWith("ms")) {
            return Long.parseLong(low.substring(0, low.length() - 2));
        }
        if (low.endsWith("m")) {
            return Long.parseLong(low.substring(0, low.length() - 1)) * 60L * 1000L;
        }
        if (low.endsWith("s")) {
            return Long.parseLong(low.substring(0, low.length() - 1)) * 1000L;
        }
        return Long.parseLong(low);
    }

    public static Object process(String url, RPCConnectException ce) throws Exception {
        if (ce.oa == null || ce.ma == null) {
            logger.info((Object)"RPCConnectException's oa or ma is null!");
            return null;
        }
        ObjectStub stub = (ObjectStub)((Object)RPCEngineFactory.getEngine(url).createObject(ce.oa.className, ce.oa.model, ce.oa.argTypes, ce.oa.args));
        Method m = stub.getClass().getMethod(ce.ma.methodName, ce.ma.methodArgTypes);
        return m.invoke((Object)stub, ce.ma.methodArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSessions(String sessionID) {
        ArrayList<RPCServerSession> result = new ArrayList<RPCServerSession>();
        IServer[] ss = ServerManager.listServers();
        for (int i = 0; i < ss.length; ++i) {
            Map sessions;
            Map map = sessions = ss[i].getSessions();
            synchronized (map) {
                for (RPCServerSession session : sessions.values()) {
                    if (!sessionID.equals(session.getContext(SESSIONID))) continue;
                    result.add(session);
                }
                continue;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBosSessionID(String sessionID) {
        logger.debug((Object)"removeBosSessionID start...");
        if (StringUtils.isEmpty((String)sessionID)) {
            return;
        }
        IServer[] ss = ServerManager.listServers();
        for (int i = 0; i < ss.length; ++i) {
            Map sessions;
            Map map = sessions = ss[i].getSessions();
            synchronized (map) {
                for (RPCServerSession session : sessions.values()) {
                    if (!sessionID.equals(session.getContext(SESSIONID))) continue;
                    session.removeContext(SESSIONID);
                    logger.info((Object)("remove bos_sessionid  " + sessionID + "  from " + session));
                }
                continue;
            }
        }
        logger.debug((Object)"removeBosSessionID end.");
    }
}

