/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.analysis;

import com.kingdee.bos.rpc.ThreadListener;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.rpc.analysis.AnalysisResult;
import com.kingdee.util.ThreadScopeLogger;
import com.kingdee.util.ThreadScopeRecord;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Analyser
implements ThreadListener {
    private static Analyser instance = new Analyser();
    private Map<Thread, Info> map = Collections.synchronizedMap(new HashMap());

    public Analyser() {
        ThreadListenerManager.addListener(this);
    }

    public static void openAnalysis(boolean isCloudRecording) {
        Thread thread = Thread.currentThread();
        Info info = new Info();
        info.enable = true;
        Analyser.instance.map.put(thread, info);
        ThreadScopeLogger.openRecord((String)"RPC Analysis", (boolean)isCloudRecording);
    }

    public static AnalysisResult endAnalysis() {
        Thread thread = Thread.currentThread();
        Analyser.instance.map.remove(thread);
        ThreadScopeRecord record = ThreadScopeLogger.endRecord();
        return Analyser.convertToAnalysisResult(record);
    }

    private static AnalysisResult convertToAnalysisResult(ThreadScopeRecord record) {
        AnalysisResult result = new AnalysisResult();
        result.fromThreadScopeRecord(record);
        return result;
    }

    public static Info getInfo() {
        Thread thread = Thread.currentThread();
        Info info = Analyser.instance.map.get(thread);
        return info;
    }

    public static boolean isEnable() {
        Thread thread = Thread.currentThread();
        Info info = Analyser.instance.map.get(thread);
        return info != null && info.enable;
    }

    @Override
    public void threadStarted(Thread thread) {
    }

    @Override
    public void threadRecycled(Thread thread) {
    }

    @Override
    public void threadFinished(Thread thread) {
        this.map.remove(thread);
    }

    @Override
    public void threadRemoved(Thread thread) {
    }

    public static class Info {
        public boolean enable = false;
        public Object request;
        public Object result;
    }
}

