/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.benchmark;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.benchmark.IDummy;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.ui.PerformancePanel;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class RPCTest
extends TestCase {
    private static Logger logger = Logger.getLogger(RPCTest.class);
    static String lanUrl;
    static String wanUrl;
    static String clusterUrl;

    public RPCTest(String name) {
        super(name);
    }

    public static void setLanUrl(String lanUrl) {
        RPCTest.lanUrl = lanUrl;
    }

    public static void setWanUrl(String wanUrl) {
        RPCTest.wanUrl = wanUrl;
    }

    public static void setClusterUrl(String clusterUrl) {
        RPCTest.clusterUrl = clusterUrl;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (lanUrl == null) {
            lanUrl = "tcp://localhost:11034";
        }
        if (wanUrl == null) {
            wanUrl = "tcp://localhost:11034";
        }
        if (clusterUrl == null) {
            clusterUrl = "tcp://localhost:11034";
        }
        PerformancePanel.showFrame("client");
    }

    public void testLAN() {
        long start = System.currentTimeMillis();
        ISession session = RPCEngineFactory.getEngine(lanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.foo();
        logger.info((Object)("testLAN simple invoke cost : " + (System.currentTimeMillis() - start)));
    }

    public void testWAN() {
        long start = System.currentTimeMillis();
        ISession session = RPCEngineFactory.getEngine(wanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.foo();
        logger.info((Object)("testWAN simple invoke cost : " + (System.currentTimeMillis() - start)));
    }

    public void testLANNoCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = -1;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(lanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testLANNoCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public void testLANCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = 0;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(lanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testLANCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public void testWANNoCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = -1;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(wanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testWANNoCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public void testWANCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = 0;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(wanUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testWANCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public void testClusterNoCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = -1;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(clusterUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testLANNoCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public void testClusterCompress() {
        long start = System.currentTimeMillis();
        RPCConfig rpcConfig = ServerManager.getConfig().copy();
        rpcConfig.minCompressSize = 0;
        ServerManager.setConfig(rpcConfig);
        ISession session = RPCEngineFactory.getEngine(clusterUrl).createSession();
        IDummy model = (IDummy)session.createObject("com.kingdee.bos.rpc.benchmark.Dummy", IDummy.class);
        model.returnRecords(100);
        logger.info((Object)("testLANCompress 100 recourds cost : " + (System.currentTimeMillis() - start)));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RPCTest.class);
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            lanUrl = args[0];
            logger.info((Object)("lanUrl : " + lanUrl));
            if (args.length > 1) {
                wanUrl = args[1];
                logger.info((Object)("wanUrl : " + wanUrl));
                if (args.length > 2) {
                    clusterUrl = args[2];
                    logger.info((Object)("clusterUrl : " + clusterUrl));
                }
            }
        }
        TestRunner.run((Test)RPCTest.suite());
    }
}

