/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.datacheck;

import com.kingdee.bos.rpc.datacheck.CheckException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DataCheck {
    public static final int EOF = Integer.MIN_VALUE;
    public static final int CREATE = 0x40000000;
    public static final int CLOSE = 0x20000000;
    public static final int COMMAND_MASK = -536870912;
    public static final int DATA_MASK = 0x1FFFFFFF;
    public static final int HEADER_LENGTH = 8;
    public static final String RPC_METHOD = "RPC_INVOKE";
    public static final String RPC_PROTOCOL = "RPC/2.0";
    public static final String NAME_URL = "rpc_url";
    public static final String NAME_PROPS = "rpc_props";
    public static final String NAME_PROTOCOL = "rpc_protocol";
    public static final int RPC_OK = 200;
    public static final int RPC_VERSION = 505;
    public static final int RPC_INTERNAL_ERROR = 500;
    public static final int RPC_BAD_METHOD = 405;

    public static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int b = 0;
        while ((b = in.read()) != -1 && b != 10) {
            if (b == 13) continue;
            out.write(b);
        }
        byte[] bytes = out.toByteArray();
        if (b == -1 && bytes.length == 0) {
            return null;
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(File file) {
        if (file.length() == 0L) {
            return;
        }
        boolean bOK = true;
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                DataCheck.check(in);
            }
            catch (CheckException ce) {
                bOK = false;
                System.out.println(file.getAbsolutePath());
                System.out.println("\t\t" + ce.toString());
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void check(DataInputStream in) throws IOException, CheckException {
        try {
            DataCheck.checkHandShake(in);
        }
        catch (Exception e) {
            if (e instanceof CheckException) {
                throw (CheckException)e;
            }
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            }
            throw new CheckException(e.toString() + " not rpc data file.");
        }
        while (true) {
            DataCheck.checkBlocks(in);
        }
    }

    private static void checkHandShake(DataInputStream in) throws IOException, CheckException {
        String line = DataCheck.readLine(in);
        if (line == null) {
            throw new CheckException("not a rpc data file");
        }
        if (!line.startsWith(RPC_METHOD) && !line.startsWith(RPC_PROTOCOL)) {
            throw new CheckException(line);
        }
        while ((line = DataCheck.readLine(in)) != null && line.length() != 0) {
        }
    }

    private static void checkBlocks(DataInputStream in) throws IOException, CheckException {
        int cmd = in.readInt();
        int len = cmd & 0x1FFFFFFF;
        if (len > 1024) {
            throw new CheckException("len = " + len);
        }
        byte[] data = null;
        if (len > 0) {
            data = new byte[len];
            in.readFully(data);
        }
        boolean eof = (cmd & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        boolean create = (cmd & 0x40000000) == 0x40000000;
        boolean close = (cmd & 0x20000000) == 0x20000000;
    }

    public static void usage() {
        System.out.println("usage: java rpc.datacheck.DataCheck path");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            DataCheck.usage();
            return;
        }
        try {
            File path = new File(args[0]);
            DataCheck.checkPath(path);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void checkPath(File path) {
        System.out.println(path.getAbsolutePath());
        File[] fs = path.listFiles();
        if (fs == null) {
            return;
        }
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            if (f.isDirectory()) {
                DataCheck.checkPath(f);
                continue;
            }
            if (!f.getName().endsWith(".request") && !f.getName().endsWith(".response")) continue;
            DataCheck.check(f);
        }
    }
}

