/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.healthdegree;

import com.kingdee.bos.rpc.healthdegree.AbstractHealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HealthDegree
implements IHealthDegree {
    private static Logger logger = Logger.getLogger(HealthDegree.class);
    private List hds = new ArrayList(1);
    private String expression;
    private boolean oom;

    public HealthDegree() {
    }

    public HealthDegree(IHealthDegree hd) {
        this.hds.add(hd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getHealthDegree() {
        if (this.oom) {
            return -2.0f;
        }
        if (this.hds.size() == 0) {
            return 0.0f;
        }
        if (StringUtils.isEmpty((String)this.expression)) {
            int ret = 0;
            for (IHealthDegree hd : this.hds) {
                float n = hd.getHealthDegree();
                if (n == -1.0f) {
                    return -1.0f;
                }
                ret = (int)((float)ret + n);
            }
            return ret / this.hds.size();
        }
        float ret = 0.0f;
        String exp = this.expression;
        for (int i = 0; i < this.hds.size(); ++i) {
            IHealthDegree hd = (IHealthDegree)this.hds.get(i);
            float hde = hd.getHealthDegree();
            if (hde == -1.0f) {
                return -1.0f;
            }
            exp = exp.replaceAll("#" + i, String.valueOf(hde));
        }
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            Object result = cx.evaluateString((Scriptable)scope, exp, "<cmd>", 1, null);
            ret = ((Number)result).floatValue();
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    public void addHealthDegreeItem(IHealthDegree hd) {
        this.hds.add(hd);
    }

    public List getHealthDegreeItem() {
        return this.hds;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void startSample() {
        for (IHealthDegree hd : this.hds) {
            if (hd instanceof AbstractHealthDegree) {
                ((AbstractHealthDegree)hd).startSample();
                continue;
            }
            try {
                hd.getClass().getMethod("startSample", new Class[0]).invoke((Object)hd, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public boolean isOom() {
        return this.oom;
    }

    public void setOom(boolean oom) {
        logger.info((Object)("HealthDegree oom " + oom));
        this.oom = oom;
    }
}

