/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCModel;
import com.kingdee.bos.rpc.impl.GenerateMethod;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.ObjectProxy;
import com.kingdee.bos.rpc.impl.ObjectStub;
import com.kingdee.bos.rpc.impl.ProxyContext;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.impl.StubContext;
import com.kingdee.bos.rpc.impl.WeakWeakMap;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.tool.classfile.ClassDefinition;
import com.tool.classfile.FieldRef;
import com.tool.classfile.InterfaceMethodRef;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.MethodRef;
import com.tool.classfile.sc;
import com.tool.simplecode.And;
import com.tool.simplecode.Assign;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.CheckCast;
import com.tool.simplecode.Cmp;
import com.tool.simplecode.GetField;
import com.tool.simplecode.If;
import com.tool.simplecode.Instanceof;
import com.tool.simplecode.InvokeInterface;
import com.tool.simplecode.InvokeSpecial;
import com.tool.simplecode.InvokeStatic;
import com.tool.simplecode.InvokeVirtual;
import com.tool.simplecode.IsNotNull;
import com.tool.simplecode.MethodCodes;
import com.tool.simplecode.New;
import com.tool.simplecode.Return;
import com.tool.simplecode.Throw;
import com.tool.simplecode.Try;
import com.tool.simplecode.Unit;
import com.tool.simplecode.Value;
import com.tool.simplecode.Variable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Generator {
    public static final Logger logger = Logger.getLogger(Generator.class);
    public static boolean buildAsm = false;
    public static final String PACKAGE_NAME = "rpc_generate";
    public static final String STUB_PREFIX = "_STUB_";
    public static final String PROXY_PREFIX = "_PROXY_";
    private static final String type_InvokeRecord = sc.classDescriptor(InvokeRecord.class);
    private static final String class_ObjectStub = sc.className(ObjectStub.class);
    private static final String type_StubContext = sc.classDescriptor(StubContext.class);
    private static final MethodRef init_ObjectStub = sc.constructor(ObjectStub.class, StubContext.class);
    private static final String ZERO = "0";
    private static final String class_ObjectProxy = sc.className(ObjectProxy.class);
    private static final MethodRef init_ObjectProxy = sc.constructor(ObjectProxy.class, ProxyContext.class);
    private static final MethodRef md_processInvoke = sc.method(ObjectProxy.class, (String)"processInvoke", Integer.TYPE, String.class, ObjectInput.class, InvokeRecord.class);
    private static final String class_Throwable = sc.className(Throwable.class);
    private static final String type_ObjectInput = sc.classDescriptor(ObjectInput.class);
    private static final MethodRef md_equals = sc.method(Object.class, (String)"equals", Object.class);
    private static final MethodRef md_readBoolean = sc.method(ObjectInput.class, (String)"readBoolean");
    private static final MethodRef md_readChar = sc.method(ObjectInput.class, (String)"readChar");
    private static final MethodRef md_readByte = sc.method(ObjectInput.class, (String)"readByte");
    private static final MethodRef md_readShort = sc.method(ObjectInput.class, (String)"readShort");
    private static final MethodRef md_readInt = sc.method(ObjectInput.class, (String)"readInt");
    private static final MethodRef md_readLong = sc.method(ObjectInput.class, (String)"readLong");
    private static final MethodRef md_readFloat = sc.method(ObjectInput.class, (String)"readFloat");
    private static final MethodRef md_readDouble = sc.method(ObjectInput.class, (String)"readDouble");
    private static final MethodRef md_readObject = sc.method(ObjectInput.class, (String)"readObject");
    private static final MethodRef md_getObject = sc.method(ObjectProxy.class, (String)"getObject");
    private static final String class_InvokeResult = sc.className(InvokeResult.class);
    private static final MethodRef md_classForName = sc.method(Class.class, (String)"forName", String.class);
    private static final String type_RPCInvoke = sc.classDescriptor(RPCInvoke.class);
    private static final String class_RPCInvoke = sc.className(RPCInvoke.class);
    private static final MethodRef init_RPCInvoke = sc.constructor(RPCInvoke.class, ObjectStub.class);
    private static final String type_InvokeResult = sc.classDescriptor(InvokeResult.class);
    private static final MethodRef md_startInvoke = sc.method(RPCInvoke.class, (String)"startInvoke", Integer.TYPE, String.class);
    private static final MethodRef md_finishInvoke = sc.method(RPCInvoke.class, (String)"finishInvoke");
    private static final MethodRef md_RPCInvoke_close = sc.method(RPCInvoke.class, (String)"close");
    private static final FieldRef fd_InvokeResult_type = sc.field(InvokeResult.class, (String)"type");
    private static final FieldRef fd_InvokeResult_value = sc.field(InvokeResult.class, (String)"value");
    private static final String type_ObjectOutput = sc.classDescriptor(ObjectOutput.class);
    private static final MethodRef md_writeBoolean = sc.method(ObjectOutput.class, (String)"writeBoolean", Boolean.TYPE);
    private static final MethodRef md_writeChar = sc.method(ObjectOutput.class, (String)"writeChar", Integer.TYPE);
    private static final MethodRef md_writeByte = sc.method(ObjectOutput.class, (String)"writeByte", Integer.TYPE);
    private static final MethodRef md_writeShort = sc.method(ObjectOutput.class, (String)"writeShort", Integer.TYPE);
    private static final MethodRef md_writeInt = sc.method(ObjectOutput.class, (String)"writeInt", Integer.TYPE);
    private static final MethodRef md_writeLong = sc.method(ObjectOutput.class, (String)"writeLong", Long.TYPE);
    private static final MethodRef md_writeFloat = sc.method(ObjectOutput.class, (String)"writeFloat", Float.TYPE);
    private static final MethodRef md_writeDouble = sc.method(ObjectOutput.class, (String)"writeDouble", Double.TYPE);
    private static final MethodRef md_writeObject = sc.method(ObjectOutput.class, (String)"writeObject", Object.class);
    private static final String type_Throwable = sc.classDescriptor(Throwable.class);
    private static final MethodRef md_createIt = sc.method(RPCException.class, (String)"createIt", Throwable.class);
    private static final MethodRef init_RPCException = sc.constructor(RPCException.class, Throwable.class);
    private static final WeakWeakMap proxyClasses = new WeakWeakMap();
    private static final WeakWeakMap stubClasses = new WeakWeakMap();
    private static final int FILE_VERSION = 1;
    private static final HashMap loaders = new HashMap();

    private static Class createClass(Class model, byte[] data) throws Exception {
        return new DynamicClassLoader(model).loadClass(null, data);
    }

    private static byte[] createClassData(ClassDefinition def, Class model, ArrayList codes) throws Exception {
        MethodCodes[] mcs = codes.toArray(new MethodCodes[codes.size()]);
        if (ServerManager.getConfig().generateProxyStubSource) {
            File sourceFile = new File(ServerManager.getConfig().tempDir, def.className + ".java");
            sourceFile.getParentFile().mkdirs();
            BuildEnv.buildSource((ClassDefinition)def, (File)sourceFile, (MethodCodes[])mcs);
        }
        for (int i = 0; i < mcs.length; ++i) {
            mcs[i].buildCodes();
        }
        if (buildAsm) {
            File sourceFile = new File(ServerManager.getConfig().tempDir, def.className + ".asm");
            sourceFile.getParentFile().mkdirs();
            def.buildAsm(sourceFile);
        }
        byte[] data = def.toByteArray();
        if (ServerManager.getConfig().saveProxyStubClass) {
            File classFile = new File(ServerManager.getConfig().tempDir, def.className + ".class");
            classFile.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(classFile), 16384);
            out.write(data);
            out.close();
        }
        return data;
    }

    private static String convertName(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                sb.append("__");
                continue;
            }
            if (c == '.') {
                sb.append("_1_");
                continue;
            }
            if (c == '/') {
                sb.append("_2_");
                continue;
            }
            if (c == '$') {
                sb.append("_3_");
                continue;
            }
            if (c == '\\') {
                sb.append("_4_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static byte[] createProxyClassData(Class model) throws Exception {
        String packageName = PACKAGE_NAME;
        String className = PROXY_PREFIX + Generator.convertName(model.getName());
        ClassDefinition def = new ClassDefinition(packageName + "/" + className, class_ObjectProxy, 1, new String[0]);
        ArrayList<MethodCodes> codes = new ArrayList<MethodCodes>();
        MethodDefinition md_init = def.declareMethod("<init>", Generator.init_ObjectProxy.descriptor, 1, new String[0]);
        md_init.args[0].name = "ctx";
        MethodCodes mc_init = new MethodCodes(md_init);
        mc_init.append((Unit)new InvokeSpecial((Unit)mc_init._this, init_ObjectProxy, new Unit[]{mc_init.args[0]}));
        mc_init.append((Unit)new Return());
        codes.add(mc_init);
        MethodDefinition md_pi = def.declareMethod(Generator.md_processInvoke.name, Generator.md_processInvoke.descriptor, 4, new String[]{class_Throwable});
        md_pi.args[0].name = "code";
        md_pi.args[1].name = "name";
        md_pi.args[2].name = "in";
        md_pi.args[3].name = "rec";
        MethodCodes mc_pi = new MethodCodes(md_pi);
        codes.add(mc_pi);
        GenerateMethod[] mds = GenerateMethod.getMethods(model);
        for (int i = 0; i < mds.length; ++i) {
            GenerateMethod gm = mds[i];
            MethodDefinition md = def.declareMethod("pi" + i, "(" + type_ObjectInput + type_InvokeRecord + ")" + type_InvokeResult, 2, new String[]{class_Throwable});
            md.args[0].name = "in";
            md.args[1].name = "rec";
            Object cond = gm.codeRepeated ? new And((Unit)new IsNotNull((Unit)mc_pi.args[1]), (Unit)new InvokeVirtual((Unit)mc_pi.args[1], md_equals, new Unit[]{new Value(gm.desc)})) : new Cmp((Unit)mc_pi.args[0], "==", (Unit)new Value(gm.code));
            If _if = new If((Unit)cond);
            _if.append((Unit)new Return((Unit)new InvokeSpecial((Unit)mc_pi._this, md.newReference(), new Unit[]{mc_pi.args[2], mc_pi.args[3]})));
            mc_pi.append((Unit)_if);
            MethodCodes mc = new MethodCodes(md);
            Generator.createProxyMethod(model, gm, mc);
            codes.add(mc);
        }
        mc_pi.append((Unit)new Return((Unit)Value.NULL));
        return Generator.createClassData(def, model, codes);
    }

    private static void createProxyMethod(Class model, GenerateMethod gm, MethodCodes mc) {
        New result;
        Method md = gm.md;
        Class<?>[] args = md.getParameterTypes();
        Unit[] ps = new Unit[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = args[i];
            Variable p = mc.declareVariable("p" + i, sc.classDescriptor(type));
            ps[i] = p;
            String typeName = sc.classDescriptor(type);
            String md_read_name = "_" + (type.isPrimitive() ? typeName : "L");
            MethodRef md_read = new MethodRef(class_ObjectProxy, md_read_name, "(I" + type_ObjectInput + type_InvokeRecord + ")" + (type.isPrimitive() ? typeName : "Ljava/lang/Object;"));
            InvokeVirtual value = new InvokeVirtual((Unit)mc._this, md_read, new Unit[]{new Value(i), mc.args[0], mc.args[1]});
            if (!type.isPrimitive() && !type.equals(Object.class)) {
                value = new CheckCast((Unit)value, typeName);
            }
            mc.append((Unit)new Assign(p, (Unit)value));
        }
        CheckCast obj = new CheckCast((Unit)new InvokeVirtual((Unit)mc._this, md_getObject, new Unit[0]), sc.className((Class)model));
        InvokeInterface iv = new InvokeInterface((Unit)obj, new InterfaceMethodRef(md), ps);
        Class<?> rType = md.getReturnType();
        if (rType.equals(Void.TYPE)) {
            mc.append((Unit)iv);
            result = new New(class_InvokeResult);
        } else {
            Object proxyType = RPCEngine.proxySpec.getMethodProxyType(md);
            if (proxyType == null) {
                result = rType.isPrimitive() ? new New(sc.constructor(InvokeResult.class, rType), (Unit)iv) : new New(sc.constructor(InvokeResult.class, Object.class), (Unit)iv);
            } else {
                Object pt = proxyType instanceof Class ? new InvokeStatic(md_classForName, new Unit[]{new Value(((Class)proxyType).getName())}) : ps[((Number)proxyType).intValue()];
                result = new New(sc.constructor(InvokeResult.class, Object.class, Class.class), (Unit)iv, pt);
            }
        }
        mc.append((Unit)new Return((Unit)result));
    }

    private static byte[] createStubClassData(Class model) throws Exception {
        String packageName = PACKAGE_NAME;
        String className = STUB_PREFIX + Generator.convertName(model.getName());
        String[] interfaces = RPCModel.class.isAssignableFrom(model) ? new String[]{sc.className((Class)model)} : new String[]{sc.className((Class)model), sc.className(RPCModel.class)};
        ClassDefinition def = new ClassDefinition(packageName + "/" + className, class_ObjectStub, 1, interfaces);
        ArrayList<MethodCodes> codes = new ArrayList<MethodCodes>();
        MethodDefinition md_init = def.declareMethod("<init>", "(" + type_StubContext + ")V", 1, new String[0]);
        md_init.args[0].name = "ctx";
        MethodCodes mc_init = new MethodCodes(md_init);
        mc_init.append((Unit)new InvokeSpecial((Unit)mc_init._this, init_ObjectStub, new Unit[]{mc_init.args[0]}));
        mc_init.append((Unit)new Return());
        codes.add(mc_init);
        GenerateMethod[] mds = GenerateMethod.getMethods(model);
        for (int i = 0; i < mds.length; ++i) {
            codes.add(Generator.createStubMethod(def, mds[i]));
        }
        return Generator.createClassData(def, model, codes);
    }

    private static MethodCodes createStubMethod(ClassDefinition def, GenerateMethod md) throws Exception {
        MethodDefinition mdef = def.declareMethod(md.md);
        MethodCodes mc = new MethodCodes(mdef);
        Variable iv = mc.declareVariable("iv", type_RPCInvoke);
        mc.append((Unit)new Assign(iv, (Unit)new New(init_RPCInvoke, (Unit)mc._this)));
        Variable r = mc.declareVariable("r", type_InvokeResult);
        Try _try = new Try();
        mc.append((Unit)_try);
        _try.append((Unit)new InvokeVirtual((Unit)iv, md_startInvoke, new Unit[]{new Value(md.codeRepeated ? 0 : md.code), new Value(md.desc)}));
        Class<?>[] argTypes = md.md.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            Class<?> type = argTypes[i];
            String typeName = sc.classDescriptor(type);
            MethodRef md_write = type.isPrimitive() ? new MethodRef(class_RPCInvoke, "_" + typeName, "(I" + typeName + ")V") : new MethodRef(class_RPCInvoke, "_L", "(ILjava/lang/Object;)V");
            _try.append((Unit)new InvokeVirtual((Unit)iv, md_write, new Unit[]{new Value(i), mc.args[i]}));
        }
        _try.append((Unit)new Assign(r, (Unit)new InvokeVirtual((Unit)iv, md_finishInvoke, new Unit[0])));
        Try.CatchBlock _catch = _try._catch(type_Throwable, "e");
        _catch.append((Unit)new InvokeVirtual((Unit)iv, md_RPCInvoke_close, new Unit[0]));
        _catch.append((Unit)new Throw((Unit)new InvokeStatic(md_createIt, new Unit[]{_catch.e})));
        mc.append((Unit)new InvokeVirtual((Unit)iv, md_RPCInvoke_close, new Unit[0]));
        If _if = new If((Unit)new Cmp((Unit)new GetField((Unit)r, fd_InvokeResult_type), "==", (Unit)new Value(0)));
        Class<?> type = md.md.getReturnType();
        if (type.isPrimitive()) {
            if (type.equals(Void.TYPE)) {
                _if.append((Unit)new Return());
            } else {
                MethodRef md_value = sc.method(InvokeResult.class, (String)sc.classDescriptor(type));
                _if.append((Unit)new Return((Unit)new InvokeVirtual((Unit)r, md_value, new Unit[0])));
            }
        } else if (type.equals(Object.class)) {
            _if.append((Unit)new Return((Unit)new GetField((Unit)r, fd_InvokeResult_value)));
        } else {
            _if.append((Unit)new Return((Unit)new CheckCast((Unit)new GetField((Unit)r, fd_InvokeResult_value), sc.classDescriptor(type))));
        }
        mc.append((Unit)_if);
        Variable err = mc.declareVariable("err", type_Throwable);
        mc.append((Unit)new Assign(err, (Unit)new CheckCast((Unit)new GetField((Unit)r, fd_InvokeResult_value), type_Throwable)));
        Class<?>[] es = md.md.getExceptionTypes();
        for (int i = 0; i < es.length; ++i) {
            String exType = sc.className(es[i]);
            _if = new If((Unit)new Instanceof((Unit)err, exType));
            _if.append((Unit)new Throw((Unit)new CheckCast((Unit)err, exType)));
            mc.append((Unit)_if);
        }
        mc.append((Unit)new Throw((Unit)new New(init_RPCException, (Unit)err)));
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(Class model) throws Exception {
        if (ServerManager.getConfig().generaterType > 0) {
            return Generator.getClass(model, PROXY_PREFIX);
        }
        if (!model.isInterface()) {
            throw new RPCException(1004, model + " is not a interface.");
        }
        WeakWeakMap weakWeakMap = proxyClasses;
        synchronized (weakWeakMap) {
            Class cls = (Class)proxyClasses.get(model);
            if (cls == null) {
                try {
                    cls = Generator.createClass(model, Generator.createProxyClassData(model));
                }
                catch (Throwable e) {
                    throw new Error(e);
                }
                proxyClasses.put(model, cls);
            }
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Class getStubClass(Class model) throws Exception {
        if (ServerManager.getConfig().generaterType > 0) {
            return Generator.getClass(model, STUB_PREFIX);
        }
        if (!model.isInterface()) {
            throw new RPCException(1004, model + " is not a interface.");
        }
        WeakWeakMap weakWeakMap = stubClasses;
        synchronized (weakWeakMap) {
            Class cls = (Class)stubClasses.get(model);
            if (cls == null) {
                try {
                    cls = Generator.createClass(model, Generator.createStubClassData(model));
                }
                catch (Throwable e) {
                    throw new Error(e);
                }
                stubClasses.put(model, cls);
            }
            return cls;
        }
    }

    private static void methodSig(Method md, StringBuffer sb) {
        sb.append("\r");
        sb.append(md.getReturnType().getName());
        sb.append(" ");
        sb.append(md.getName());
        sb.append("(");
        Class<?>[] argTypes = md.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(argTypes[i].getName());
        }
        sb.append(")");
        Class<?>[] es = md.getExceptionTypes();
        if (es != null && es.length > 0) {
            sb.append("throws ");
            for (int i = 0; i < es.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(es[i].getName());
            }
        }
        sb.append("\n");
    }

    private static String classSig(Class model) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("public interface " + model.getName() + "\n{\n");
        Method[] mds = model.getMethods();
        Object[] sigs = new String[mds.length];
        for (i = 0; i < mds.length; ++i) {
            StringBuffer sb1 = new StringBuffer();
            Generator.methodSig(mds[i], sb1);
            sigs[i] = sb1.toString();
        }
        Arrays.sort(sigs);
        for (i = 0; i < sigs.length; ++i) {
            sb.append((String)sigs[i]);
        }
        sb.append("}\r\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Class getClass(Class model, String prefix) throws Exception {
        Class cls;
        block26: {
            URL url;
            if (!model.isInterface()) {
                throw new RPCException(1004, model + " is not a interface.");
            }
            String className = "rpc_generate." + prefix + Generator.convertName(model.getName());
            ClassLoader loaderKey = model.getClassLoader();
            DynamicClassLoader loader = (DynamicClassLoader)loaders.get(loaderKey);
            if (loader == null) {
                loader = new DynamicClassLoader(model);
                loaders.put(loaderKey, loader);
            }
            cls = null;
            try {
                cls = loader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (cls != null) {
                return cls;
            }
            int generaterType = ServerManager.getConfig().generaterType;
            String classUrl = ZERO;
            CodeSource codeSrc = model.getProtectionDomain().getCodeSource();
            if (codeSrc != null && (url = codeSrc.getLocation()) != null) {
                classUrl = url.toString();
            }
            File classFile = new File(ServerManager.getConfig().tempDir, Integer.toHexString(classUrl.hashCode()) + "/" + className.replace('.', '/') + ".data");
            String sig = null;
            if (generaterType == 2 && classFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("load '" + className + "' from '" + classFile.getAbsolutePath() + "'"));
                }
                try {
                    DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(classFile)));
                    try {
                        if (1 == in.readInt()) {
                            String sig1;
                            int len = in.readInt();
                            byte[] data = new byte[len];
                            in.readFully(data);
                            if (sig == null) {
                                sig = Generator.classSig(model);
                            }
                            if (!(sig1 = new String(data)).equals(sig)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("class '" + model.getName() + "' modified."));
                                }
                            } else {
                                len = in.readInt();
                                data = new byte[len];
                                in.readFully(data);
                                cls = loader.loadClass(className, data);
                            }
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Throwable ex) {
                    logger.debug((Object)("load '" + className + "' failed."), ex);
                }
            }
            if (cls != null) {
                return cls;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("create class '" + className + "'"));
            }
            byte[] data = prefix.equals(STUB_PREFIX) ? Generator.createStubClassData(model) : Generator.createProxyClassData(model);
            cls = loader.loadClass(className, data);
            if (generaterType == 2) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("save '" + className + "' to '" + classFile.getAbsolutePath() + "'"));
                    }
                    classFile.getParentFile().mkdirs();
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(classFile)));
                    out.writeInt(1);
                    if (sig == null) {
                        sig = Generator.classSig(model);
                    }
                    byte[] sigData = sig.getBytes();
                    out.writeInt(sigData.length);
                    out.write(sigData);
                    out.writeInt(data.length);
                    out.write(data);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block26;
                    logger.debug((Object)("save '" + className + "' faild."), (Throwable)e);
                }
            }
        }
        return cls;
    }

    private static class DynamicClassLoader
    extends ClassLoader {
        DynamicClassLoader(Class model) {
            super(model.getClassLoader());
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            try {
                return RPCEngine.loadClass(name);
            }
            catch (Throwable throwable) {
                return super.findClass(name);
            }
        }

        Class loadClass(String name, byte[] data) {
            Class<?> cls = this.defineClass(name, data, 0, data.length, Object.class.getProtectionDomain());
            this.resolveClass(cls);
            return cls;
        }
    }
}

