/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.BothObjectOutput;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.impl.RPCObjectInputStream;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class IOUtil {
    public static final Logger logger = Logger.getLogger(IOUtil.class);
    public static final String encodingChars = " /\\&?%=;:";

    public static void close(Object x) {
        block28: {
            try {
                if (x == null) {
                    return;
                }
                if (x instanceof InputStream) {
                    ((InputStream)x).close();
                    break block28;
                }
                if (x instanceof OutputStream) {
                    ((OutputStream)x).close();
                    break block28;
                }
                if (x instanceof ObjectInput) {
                    ((ObjectInput)x).close();
                    break block28;
                }
                if (x instanceof ObjectOutput) {
                    ((ObjectOutput)x).close();
                    break block28;
                }
                if (x instanceof Socket) {
                    Socket sock = (Socket)x;
                    try {
                        sock.shutdownOutput();
                    }
                    catch (Throwable _) {
                        // empty catch block
                    }
                    try {
                        sock.shutdownInput();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    sock.close();
                    break block28;
                }
                if (x instanceof ServerSocket) {
                    ((ServerSocket)x).close();
                } else if (x instanceof InvokeHelper) {
                    ((InvokeHelper)x).close();
                } else if (x instanceof ContainerBase) {
                    ((ContainerBase)x).close();
                } else if (x instanceof Connection) {
                    ((Connection)x).close();
                } else if (x instanceof Channel) {
                    ((Channel)x).close();
                } else if (x instanceof NIOSocket) {
                    ((NIOSocket)x).close();
                } else if (x instanceof Selector) {
                    ((Selector)x).close();
                } else if (x instanceof SelectionKey) {
                    ((SelectionKey)x).cancel();
                } else {
                    x.getClass().getMethod("close", new Class[0]).invoke(x, new Object[0]);
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException) break block28;
                logger.debug((Object)e, e);
            }
        }
    }

    public static ObjectOutput createBothObjectOutput(ObjectOutput o1, ObjectOutput o2) {
        return new BothObjectOutput(o1, o2);
    }

    public static void writeLine(OutputStream out) throws IOException {
        IOUtil.writeLine(out, null);
    }

    public static void writeLine(OutputStream out, String line) throws IOException {
        line = line == null ? "\r\n" : line + "\r\n";
        out.write(line.getBytes());
    }

    public static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int b = 0;
        while ((b = in.read()) != -1 && b != 10) {
            if (b == 13) continue;
            out.write(b);
        }
        byte[] bytes = out.toByteArray();
        if (b == -1 && bytes.length == 0) {
            return null;
        }
        return new String(bytes);
    }

    public static byte[] readFully(InputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        IOUtil.readFully(in, b, 0, len);
        return b;
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int l = in.read(b, off, len);
            if (l < 0) {
                throw new EOFException();
            }
            off += l;
            len -= l;
        }
    }

    public static DataOutputStream getDataOutputStream(OutputStream out) {
        if (out instanceof DataOutputStream) {
            return (DataOutputStream)out;
        }
        return new DataOutputStream(out);
    }

    public static DataInputStream getDataInputStream(InputStream in) {
        if (in instanceof DataInputStream) {
            return (DataInputStream)in;
        }
        return new DataInputStream(in);
    }

    public static void writeBytes(OutputStream out, byte[] b) throws IOException {
        DataOutputStream dout = IOUtil.getDataOutputStream(out);
        if (b == null) {
            dout.writeInt(-1);
        } else {
            dout.writeInt(b.length);
            dout.write(b);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        DataInputStream din = IOUtil.getDataInputStream(in);
        int len = din.readInt();
        if (len < 0) {
            return null;
        }
        byte[] b = new byte[len];
        if (len > 0) {
            din.readFully(b);
        }
        return b;
    }

    public static byte[] objectToBytes(Object x) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(x);
        out.close();
        return bout.toByteArray();
    }

    public static Object bytesToObject(byte[] b) throws IOException, ClassNotFoundException {
        if (b == null || b.length == 0) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        RPCObjectInputStream in = new RPCObjectInputStream(bin);
        return in.readObject();
    }

    public static void writeObject(OutputStream out, Object x) throws IOException {
        IOUtil.writeBytes(out, IOUtil.objectToBytes(x));
    }

    public static Object readObject(InputStream in) throws IOException, ClassNotFoundException {
        return IOUtil.bytesToObject(IOUtil.readBytes(in));
    }

    public static void writeProperties(OutputStream out, Properties props) throws IOException {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                IOUtil.writeLine(out, IOUtil.encode(name) + " :" + IOUtil.encode(value));
            }
        }
        IOUtil.writeLine(out);
    }

    public static Properties readProperties(InputStream in, Properties props) throws IOException {
        String line;
        if (props == null) {
            props = new Properties();
        }
        while ((line = IOUtil.readLine(in)) != null && line.length() != 0) {
            int index = line.indexOf(58);
            if (index <= 0) continue;
            String name = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            props.setProperty(IOUtil.decode(name), IOUtil.decode(value));
        }
        return props;
    }

    public static Properties appendProperties(Properties src, Properties append) {
        if (src == null) {
            src = new Properties();
        }
        if (append != null) {
            Enumeration<?> e = append.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                src.setProperty(name, append.getProperty(name));
            }
        }
        return src;
    }

    public static String getProperty(HashMap map, String name) {
        if (map == null) {
            return null;
        }
        Object value = map.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static void intToBytes(int value, byte[] b, int off) {
        b[off++] = (byte)(value >> 24);
        b[off++] = (byte)(value >> 16 & 0xFF);
        b[off++] = (byte)(value >> 8 & 0xFF);
        b[off] = (byte)(value & 0xFF);
    }

    public static int intFromBytes(byte[] b, int off) {
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static String encode(Properties props) {
        return IOUtil.encode(IOUtil.propertiesToString(props));
    }

    public static String encode(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            int c = 0xFFFF & s.charAt(i);
            if (c >= 0 && c <= 32 || c >= 128 || encodingChars.indexOf(c) >= 0) {
                sb.append("%");
                sb.append(Integer.toHexString(c | Integer.MIN_VALUE).substring(4));
                continue;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String decode(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                sb.append(c);
                continue;
            }
            sb.append((char)Integer.parseInt(s.substring(++i, i + 4), 16));
            i += 3;
        }
        return sb.toString();
    }

    public static String propertiesToString(Properties props) {
        StringBuffer sb = new StringBuffer();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                sb.append(IOUtil.encode(name) + "=" + IOUtil.encode(value) + ";");
            }
        }
        return sb.toString();
    }

    private static void setProperty(Properties props, String s) {
        int index = s.indexOf(61);
        if (index >= 0) {
            String name = s.substring(0, index).trim();
            String value = s.substring(index + 1).trim();
            if (name.length() > 0) {
                props.setProperty(IOUtil.decode(name), IOUtil.decode(value));
            }
        }
    }

    public static Properties propertiesFromString(String s) {
        return IOUtil.propertiesFromString(s, null);
    }

    public static Properties propertiesFromString(String s, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        if (s != null) {
            while (true) {
                int index;
                if ((index = s.indexOf(59)) < 0) {
                    IOUtil.setProperty(props, s);
                    break;
                }
                IOUtil.setProperty(props, s.substring(0, index));
                s = s.substring(index + 1);
            }
        }
        return props;
    }

    public static void logIOError(Logger logger, Throwable e) {
        if (ServerManager.getConfig().logIOExceptions || !(e instanceof IOException)) {
            logger.info((Object)"", e);
        }
    }

    public static int getPropertyInt(Properties props, String name, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String value = props.getProperty(name, null);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLog4j() {
        Logger root;
        Logger logger = root = Logger.getRootLogger();
        synchronized (logger) {
            if (!root.getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
        }
    }

    public static InputStream limitInputStream(InputStream in, String name, int maxSize) {
        return new LimitInput(in, name, maxSize);
    }

    public static void checkDataSize(String name, int size, int maxSize) {
        if (size > maxSize) {
            throw new RPCException(1006, name + " size too large(" + size + ">" + maxSize + ").");
        }
    }

    public static OutputStream limitOutputStream(OutputStream out, String name, int maxSize) {
        return new LimitOutput(out, name, maxSize);
    }

    public static InputStream limitInputStream(InputStream in, boolean compressed) {
        int maxSize = ServerManager.getConfig().getMaxDataSize(compressed);
        if (maxSize <= 0) {
            return in;
        }
        return IOUtil.limitInputStream(in, compressed ? "compressed data" : "data", maxSize);
    }

    public static OutputStream limitOutputStream(OutputStream out, boolean compressed) {
        int maxSize = ServerManager.getConfig().getMaxDataSize(compressed);
        if (maxSize <= 0) {
            return out;
        }
        return IOUtil.limitOutputStream(out, compressed ? "compressed data" : "data", maxSize);
    }

    private static class LimitInput
    extends InputStream {
        final InputStream in;
        final int maxSize;
        int size = 0;
        final String name;

        LimitInput(InputStream in, String name, int maxSize) {
            this.in = in;
            this.maxSize = maxSize;
            this.name = name;
        }

        private void append(int r) {
            this.size += r;
            IOUtil.checkDataSize(this.name, this.size, this.maxSize);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            int r = this.in.read();
            if (r != -1) {
                this.append(1);
            }
            return r;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            if (r > 0) {
                this.append(r);
            }
            return r;
        }
    }

    private static class LimitOutput
    extends OutputStream {
        final OutputStream out;
        final String name;
        final int maxSize;
        int size = 0;

        LimitOutput(OutputStream out, String name, int maxSize) {
            this.out = out;
            this.name = name;
            this.maxSize = maxSize;
        }

        private void append(int c) {
            this.size += c;
            IOUtil.checkDataSize(this.name, this.size, this.maxSize);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.append(len);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.append(1);
            this.out.write(b);
        }
    }
}

