/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.recordSlowReq.RecordSlowReqSwitch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RPCRecordStatus {
    private static HashMap status = new HashMap();
    private static HashMap requests = new HashMap();
    private static ArrayList threads = new ArrayList();
    private static HashMap events = new HashMap();
    private static boolean on;

    public static synchronized void clear() {
        status.clear();
        requests.clear();
        threads.clear();
        events.clear();
    }

    public static synchronized boolean isOn() {
        return on;
    }

    public static synchronized void turnOn() {
        on = true;
    }

    public static synchronized void turnOff() {
        on = false;
    }

    public static synchronized void turnOnThread() {
        status.put(Thread.currentThread(), "On");
    }

    public static synchronized void turnOffThread() {
        status.put(Thread.currentThread(), "Off");
    }

    public static synchronized boolean isOnThread() {
        return RecordSlowReqSwitch.getActionRecord() != null || on && "On".equals(status.get(Thread.currentThread()));
    }

    public static synchronized RPCRequest createRPCRequest() {
        RPCRequest request = new RPCRequest();
        request.threadName = Thread.currentThread().getName();
        request.eventInfo = (RPCRequest.EventInfo)events.get(Thread.currentThread());
        if (RecordSlowReqSwitch.getActionRecord() != null) {
            RecordSlowReqSwitch.addRPCSlowRquest(request);
        }
        if (RPCRecordStatus.isOn()) {
            ArrayList<RPCRequest> list = (ArrayList<RPCRequest>)requests.get(Thread.currentThread());
            if (list == null) {
                list = new ArrayList<RPCRequest>();
                threads.add(Thread.currentThread());
                requests.put(Thread.currentThread(), list);
            }
            list.add(request);
        }
        return request;
    }

    public static List getAllRequests() {
        ArrayList list = new ArrayList();
        for (Object key : threads) {
            list.addAll((ArrayList)requests.get(key));
        }
        return list;
    }

    public static void removeRequest(RPCRequest request) {
        Object key;
        ArrayList list;
        Iterator iter = threads.iterator();
        while (iter.hasNext() && !(list = (ArrayList)requests.get(key = iter.next())).remove(request)) {
        }
    }

    public static void setCurrentEventInfo(RPCRequest.EventInfo eventInfo) {
        events.put(Thread.currentThread(), eventInfo);
    }
}

