/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.analysis.AnalysisResult;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.IValueJudge;

public class RPCResult {
    public static String CURRENT_VERSION = "2.0";
    public String version = CURRENT_VERSION;
    public final long startTime;
    public final long endTime;
    public boolean isException;
    public Throwable exception;
    public Object value;
    public String requestName;
    public AnalysisResult analysisResult;

    public RPCResult(long starttime, long endtime, boolean isException, Throwable exception, Object value) {
        this.startTime = starttime;
        this.endTime = endtime;
        this.isException = isException;
        this.exception = exception;
        this.value = value;
    }

    public RPCResult(String version, long starttime, long endtime, boolean isException, Throwable exception, Object value) {
        this.version = version;
        this.startTime = starttime;
        this.endTime = endtime;
        this.isException = isException;
        this.exception = exception;
        this.value = value;
    }

    public void upgrade(Context ctx) {
        if (!this.version.equals(CURRENT_VERSION)) {
            IValueJudge.Factory factory = (IValueJudge.Factory)ctx.get(IValueJudge.Factory.class);
            IValueJudge vj = factory.createValueJudge(this.value);
            this.isException = vj.isException();
            this.exception = vj.getException();
            this.value = vj.getValue();
        }
    }
}

