/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.ObjectMarshaler;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc.ce.ObjectArgs;
import com.kingdee.bos.rpc.impl.Generator;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.IdleTimeoutMonitor;
import com.kingdee.bos.rpc.impl.LocalReference;
import com.kingdee.bos.rpc.impl.ObjectStub;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.impl.RPCMonitor;
import com.kingdee.bos.rpc.impl.RPCObjectInputStream;
import com.kingdee.bos.rpc.impl.RemoteArrayReference;
import com.kingdee.bos.rpc.impl.RemoteReference;
import com.kingdee.bos.rpc.impl.StubContext;
import com.kingdee.bos.rpc.impl.StubFinalizer;
import com.kingdee.bos.rpc.impl.WeakWeakMap;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.util.LRUMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RPCSessionImpl
extends RPCSession {
    private static final Logger logger = Logger.getLogger(RPCSessionImpl.class);
    private static final IntValue sessionCount = PerformanceManager.getIntValue("ClientSession.count");
    private static final IntValue stubCount = PerformanceManager.getIntValue("ClientSession.stubCount");
    private final IdleTimeoutMonitor keepAlive;
    ObjectArgs oa;
    private final LRUMap cache;
    private final WeakWeakMap stubs = new WeakWeakMap();
    private final StubFinalizer finalizer = new StubFinalizer(this);

    RPCSessionImpl(long sessionId, Connector cn, boolean stateable) {
        super(sessionId, cn, stateable);
        this.cache = new LRUMap(10000);
        sessionCount.append(1);
        if (stateable) {
            this.keepAlive = new IdleTimeoutMonitor(ServerManager.getConfig().sessionKeepAliveInterval){

                @Override
                protected void onIdleTimeout() {
                    RPCSessionImpl.this.keepAlive();
                }
            };
            RPCMonitor.addWeakMonitor(this.keepAlive);
        } else {
            this.keepAlive = null;
        }
        if (ServerManager.getConfig().logSessionCreate) {
            logger.info((Object)(this.toString() + " created."));
        }
    }

    void keepAlive() {
        if (!this.stateable) {
            return;
        }
        try {
            if (!this.isClosed()) {
                if (ServerManager.getConfig().logSessionKeepAlive && this.keepAlive.isTimeout()) {
                    logger.info((Object)(this.toString() + " keep alive."));
                }
                RPCInvoke.keepAlive(this);
            }
        }
        catch (Throwable e) {
            IOUtil.logIOError(logger, e);
        }
    }

    void enterService() {
        if (!this.stateable) {
            return;
        }
        this.keepAlive.enter();
    }

    void leaveService() {
        if (!this.stateable) {
            return;
        }
        this.keepAlive.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object createObjectStub(Class model, long ref) {
        this.validate();
        try {
            StubContext ctx = new StubContext(this, model, ref);
            WeakWeakMap weakWeakMap = this.stubs;
            synchronized (weakWeakMap) {
                Class stubClass = Generator.getStubClass(model);
                Object stub = stubClass.getConstructor(StubContext.class).newInstance(ctx);
                stubCount.append(1);
                return stub;
            }
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public static Object getObjectModel(ObjectStub stub, Class model) {
        return RPCInvoke.getObjectModel(stub, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseObject(ObjectStub stub) {
        StubContext stubContext = stub.ctx;
        synchronized (stubContext) {
            if (stub.released) {
                return;
            }
            stub.released = true;
        }
        stubCount.append(-1);
        stub.ctx.session.releaseObjectStub(stub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseObjectStub(ObjectStub stub) {
        if (this.isClosed()) {
            return;
        }
        try {
            StubContext ctx = stub.ctx;
            WeakWeakMap weakWeakMap = this.stubs;
            synchronized (weakWeakMap) {
                this.stubs.remove(ctx);
            }
            this.finalizer.addStub(ctx.ref);
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    ObjectOutput createOutputStream(OutputStream out) throws IOException {
        ObjectOutput out1 = new Output(this, out);
        ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
        if (objectMarshaler != null) {
            out1 = objectMarshaler.createOutput(out1);
        }
        return out1;
    }

    ObjectInput createInputStream(InputStream in, Class model) throws IOException {
        ObjectInput in1 = new Input(this, model, in);
        ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
        if (objectMarshaler != null) {
            in1 = objectMarshaler.createInput(in1);
        }
        return in1;
    }

    @Override
    public Object createObject(String name, Class model, Class[] argTypes, Object[] args) throws RPCException {
        this.validate();
        Object obj = null;
        obj = System.getProperty("easclient.root") == null ? RPCInvoke.createObjectImpl(this, name, model, argTypes, args) : RPCInvoke.createObject(this, name, model, argTypes, args);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalClose() throws Throwable {
        sessionCount.append(-1);
        try {
            if (this.keepAlive != null) {
                RPCMonitor.removeMonitor(this.keepAlive);
            }
            this.cn.closeSession(this.getSessionId());
            WeakWeakMap weakWeakMap = this.stubs;
            synchronized (weakWeakMap) {
                this.stubs.clear();
            }
            super.finalClose();
        }
        finally {
            if (ServerManager.getConfig().logSessionClose) {
                logger.info((Object)(this.toString() + " closed."));
            }
        }
    }

    protected void validate() throws RPCException {
        if (this.isClosed()) {
            throw new RPCException(1001, "Session#" + this.sessionId + " has been closed.");
        }
    }

    InvokeHelper newInvokeHelper() throws IOException {
        return this.newInvokeHelper(false);
    }

    InvokeHelper newInvokeHelper(boolean forClose) throws IOException {
        if (!forClose) {
            this.validate();
        }
        return this.cn.newInvokeHelper();
    }

    static Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        Input input = (Input)((ObjectMarshaler.Delegater)((Object)in)).getDelegater();
        return input.resolveObject(in.readObject());
    }

    private static class Output
    extends ObjectOutputStream
    implements ObjectMarshaler.Delegater {
        final RPCSessionImpl session;
        boolean substitutionPermission = true;

        @Override
        public Object getDelegater() {
            return this;
        }

        Output(RPCSessionImpl session, OutputStream out) throws IOException {
            super(out);
            this.session = session;
            try {
                this.enableReplaceObject(true);
            }
            catch (SecurityException _) {
                this.substitutionPermission = false;
            }
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj == null) {
                return null;
            }
            if (obj instanceof ObjectStub) {
                ObjectStub stub = (ObjectStub)obj;
                if (stub.ctx.session == this.session) {
                    return new LocalReference(stub.ctx.ref);
                }
            }
            return obj;
        }
    }

    private static class Input
    extends RPCObjectInputStream
    implements ObjectMarshaler.Delegater {
        final RPCSessionImpl session;
        final Class model;
        boolean substitutionPermission = true;
        private final HashMap map = new HashMap();

        @Override
        public Object getDelegater() {
            return this;
        }

        Input(RPCSessionImpl session, Class model, InputStream in) throws IOException {
            super(in);
            this.session = session;
            this.model = model;
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException _) {
                this.substitutionPermission = false;
            }
        }

        @Override
        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                if (this.model != null) {
                    return this.checkClass(this.model.getClassLoader().loadClass(desc.getName()), desc);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return super.resolveClass(desc);
        }

        @Override
        public void close() throws IOException {
            this.map.clear();
            super.close();
        }

        private Object createRemoteArray(RemoteArrayReference ref) throws IOException {
            Object value = this.map.get(ref);
            if (value != null) {
                return value;
            }
            Object[] ar = ref.items;
            Object[] values = (Object[])Array.newInstance(ref.componentType, ar.length);
            this.map.put(ref, values);
            for (int i = 0; i < ar.length; ++i) {
                values[i] = this.resolveObject(ar[i]);
            }
            return values;
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj == null) {
                return null;
            }
            if (obj instanceof RemoteReference) {
                RemoteReference ref = (RemoteReference)obj;
                Object value = this.map.get(ref);
                if (value == null) {
                    value = this.session.createObjectStub(ref.model, ref.ref);
                    this.map.put(ref, value);
                }
                return value;
            }
            if (obj instanceof RemoteArrayReference) {
                RemoteArrayReference ref = (RemoteArrayReference)obj;
                return this.createRemoteArray(ref);
            }
            return obj;
        }
    }
}

