/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.util.ArrayList;

class StubFinalizer
implements Runnable {
    final RPCSessionImpl session;
    private volatile boolean alive = false;
    private final ArrayList stubs = new ArrayList();

    StubFinalizer(RPCSessionImpl session) {
        this.session = session;
    }

    synchronized void addStub(long id) {
        if (id < 0L) {
            return;
        }
        this.stubs.add(new Long(id));
        if (!this.alive) {
            this.alive = true;
            RPCEngine.startThread(this);
        }
    }

    synchronized long[] getStubs() {
        long[] ids = new long[this.stubs.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Long)this.stubs.get(i);
        }
        this.stubs.clear();
        this.alive = false;
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long delay = ServerManager.getConfig().releaseDelayInterval;
            int maxSize = ServerManager.getConfig().maxStubReleaseSize;
            StubFinalizer stubFinalizer = this;
            synchronized (stubFinalizer) {
                int size = this.stubs.size();
                while (size < maxSize) {
                    this.wait(delay);
                    if (size == this.stubs.size()) break;
                    size = this.stubs.size();
                }
            }
        }
        catch (Throwable _) {
            // empty catch block
        }
        try {
            RPCInvoke.releaseObject(this);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.alive = false;
        }
    }
}

