/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;

public abstract class ThreadPool {
    public static final int DEFAULT_MIN_SIZE = 0;
    public static final int DEFAULT_MAX_SIZE = 30;
    public static final int DEFAULT_IDLE_TIMEOUT = 60000;
    protected int minSize;
    protected int maxSize;
    protected long idleTimeout;
    public final String name;
    private long workId = 1L;
    protected final IntValue freeCount;
    protected final IntValue activeCount;

    protected synchronized String nextName() {
        return this.name + "-" + this.workId++;
    }

    protected ThreadPool(String name, int minSize, int maxSize, long idleTimeout) {
        this.name = name;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.idleTimeout = idleTimeout;
        this.freeCount = PerformanceManager.getIntValue("ThreadPool.freeCount");
        this.activeCount = PerformanceManager.getIntValue("ThreadPool.activeCount");
    }

    public synchronized int getMinSize() {
        return this.minSize;
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized long getIdleTimeout() {
        return this.idleTimeout;
    }

    public synchronized void setParameters(int minSize, int maxSize, long idleTimeout) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.idleTimeout = idleTimeout;
    }

    public abstract void startThread(Runnable var1);
}

