/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.rpc.impl.RejectedExecutionHandlerReImpl;
import com.kingdee.bos.rpc.impl.SynchronousQueueReImpl;
import com.kingdee.bos.rpc.impl.ThreadPool;
import com.kingdee.bos.rpc.impl.ThreadPoolExecutorReImpl;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ThreadPool3
extends ThreadPool {
    private static Logger logger = Logger.getLogger(ThreadPool3.class);
    public volatile AExecutor pool;
    private int MAX = 30000;
    public final int IDLETIMEOUT = 120000;
    private int corePoolSize = 5;

    private static Object getObject(Object cache, String filedName) {
        Class<?> c = cache.getClass();
        Field field = null;
        try {
            while (c != null && field == null) {
                try {
                    field = c.getDeclaredField(filedName);
                }
                catch (Exception e) {
                    c = c.getSuperclass();
                }
            }
            if (field == null) {
                return "";
            }
            field.setAccessible(true);
            return field.get(cache);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Object getFiledValue(String filedName, Object obj) {
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(filedName);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return null;
    }

    public ThreadPool3(final String name) {
        super("RPC", 5, 5, 100L);
        ThreadFactory threadFactory = new ThreadFactory(){
            AtomicInteger index = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, name + "-" + this.index.incrementAndGet());
                thread.setDaemon(false);
                return thread;
            }
        };
        final SynchronousQueueReImpl<Runnable> queue = new SynchronousQueueReImpl<Runnable>(false);
        RejectedExecutionHandlerReImpl handler = new RejectedExecutionHandlerReImpl(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutorReImpl executor) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RPCException(3001, "can't not allocate thread by threadpool.");
                }
            }
        };
        this.pool = new AExecutor(this.corePoolSize, 120000L, queue, threadFactory, handler);
        boolean isLogThreadPool = false;
        if (isLogThreadPool) {
            new Thread("adddddddd"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                HashSet hs = (HashSet)ThreadPool3.getObject(ThreadPool3.this.pool, "workers");
                                logger.error((Object)("pool3 threadCount:" + hs.size() + "   " + " pool3 activeCount:" + ThreadPool3.this.pool.getActiveCount()));
                                Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                                Set<Thread> set = map.keySet();
                                StackTraceElement[] e = null;
                                HashMap<String, AtomicInteger> traceCount = new HashMap<String, AtomicInteger>();
                                for (Thread t : set) {
                                    if (!t.getName().startsWith("RPC")) continue;
                                    e = map.get(t);
                                    StringBuffer trace = new StringBuffer();
                                    for (int j = 0; j < e.length && j <= 5; ++j) {
                                        trace.append(e[j].getClassName()).append(" .").append(e[j].getMethodName()).append("() ").append(e[j].getLineNumber()).append("  ");
                                    }
                                    if (traceCount.containsKey(trace.toString())) {
                                        ((AtomicInteger)traceCount.get(trace.toString())).incrementAndGet();
                                        continue;
                                    }
                                    traceCount.put(trace.toString(), new AtomicInteger(1));
                                }
                                ValueComparator bvc = new ValueComparator(traceCount);
                                TreeMap<String, AtomicInteger> sorted_map = new TreeMap<String, AtomicInteger>(bvc);
                                sorted_map.putAll(traceCount);
                                sorted_map.comparator();
                                String s = sorted_map.toString();
                                if (s.length() > 300) {
                                    s.subSequence(0, 300);
                                }
                                logger.error((Object)("pool3 top thread " + s));
                                Thread.sleep(12000L);
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    @Override
    public void setParameters(int minSize, int maxSize, long idleTimeout) {
        this.corePoolSize = minSize;
        if (maxSize > 3000) {
            this.MAX = maxSize;
            this.pool.setMaximumPoolSize(this.MAX);
        }
        this.pool.setCorePoolSize(this.corePoolSize);
    }

    @Override
    public void startThread(Runnable runner) {
        this.pool.submit(runner);
    }

    private class AExecutor
    extends ThreadPoolExecutorReImpl {
        AExecutor(int corePoolSize1, long idleTimeout, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandlerReImpl handler) {
            super(corePoolSize1, ThreadPool3.this.MAX, 120000L, TimeUnit.MILLISECONDS, workQueue, threadFactory, handler);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            ThreadPool3.this.activeCount.append(1);
            ThreadListenerManager.fireStartedEvent(t);
        }

        @Override
        public void execute(Runnable command) {
            long t1 = System.currentTimeMillis();
            super.execute(command);
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 1000L) {
                long t3 = System.currentTimeMillis();
                String s = "threadpool execute too slow:" + (t2 - t1) + "ms." + "t2 to t3:" + (t3 - t2) + "    offerCount: " + SynchronousQueueReImpl.offerCount.get() + ", pollCount: " + SynchronousQueueReImpl.pollCount.get() + "\u3000threadCount:" + ((HashSet)ThreadPool3.getObject(ThreadPool3.this.pool, "workers")).size() + " activeCount:" + ThreadPool3.this.pool.getActiveCount();
                logger.error((Object)s, (Throwable)new Exception());
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            ThreadPool3.this.activeCount.append(-1);
            ThreadListenerManager.fireFinishedEvent(Thread.currentThread());
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, AtomicInteger> base;

        public ValueComparator(Map<String, AtomicInteger> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this.base.get(a).intValue() >= this.base.get(b).intValue()) {
                return -1;
            }
            return 1;
        }
    }
}

