/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;

public class UniqueID {
    private static final MessageDigest md = UniqueID.initMessageDigest();

    public static String next() {
        return UniqueID.next((byte[])null);
    }

    public static String next(String append) {
        return UniqueID.next(append == null ? null : append.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String next(byte[] append) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (append == null) {
                md.update((byte)0);
            } else {
                md.update(Integer.toString(append.length).getBytes());
                md.update(append);
            }
            md.update(Long.toString(System.currentTimeMillis()).getBytes());
            try {
                append = ((MessageDigest)md.clone()).digest();
            }
            catch (Exception e) {
                throw new Error(e.toString());
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < append.length; ++i) {
            int c = 0xFF & append[i];
            int h = c / 16;
            int l = c & 0xF;
            sb.append((char)(h < 10 ? 48 + h : 65 + h - 10));
            sb.append((char)(l < 10 ? 48 + l : 65 + l - 10));
        }
        return sb.toString();
    }

    private static MessageDigest getMessageDigest(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException _) {
            return null;
        }
    }

    private static MessageDigest initMessageDigest() {
        MessageDigest md = UniqueID.getMessageDigest("SHA-1");
        if (md == null) {
            md = UniqueID.getMessageDigest("MD5");
        }
        if (md == null) {
            md = UniqueID.getMessageDigest("MD2");
        }
        if (md == null) {
            throw new Error("No message digest algorithms(SHA-1 or MD5 or MD2).");
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println(System.currentTimeMillis());
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            out.println(sock.getLocalSocketAddress());
        }
        catch (Throwable _) {
            // empty catch block
        }
        out.println(new File("").getAbsoluteFile().getAbsolutePath());
        out.println(System.getProperties());
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface netif = e1.nextElement();
                Enumeration<InetAddress> e2 = netif.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress addr = e2.nextElement();
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                    out.println(addr);
                }
            }
        }
        catch (Throwable _) {
            // empty catch block
        }
        try {
            Thread.sleep(100L);
            out.println(System.currentTimeMillis());
            if (sock != null) {
                sock.close();
            }
        }
        catch (Throwable _) {
            // empty catch block
        }
        out.println(md.toString());
        out.close();
        md.update(sw.toString().getBytes());
        return md;
    }
}

