/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.io.RPCIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class CompressOutputStream
extends OutputStream {
    public final OutputStream out;
    public final int minCompressSize;
    private final byte[] buf;
    private GZIPOutputStream zipOut = null;
    private int pos = 0;
    private boolean closed = false;

    public CompressOutputStream(OutputStream out, int minCompressSize) {
        this.out = out;
        this.minCompressSize = minCompressSize;
        this.buf = new byte[minCompressSize];
    }

    private void validate() throws IOException {
        if (this.closed) {
            throw new RPCIOException(2003, "Stream closed.");
        }
    }

    private void flushData() throws IOException {
        if (this.zipOut == null) {
            this.out.write(1);
            this.zipOut = new GZIPOutputStream(this.out);
        }
        if (this.pos > 0) {
            this.zipOut.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.validate();
        if (this.pos >= this.buf.length) {
            this.flushData();
        }
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.zipOut == null) {
            this.out.write(0);
            if (this.pos > 0) {
                this.out.write(this.buf, 0, this.pos);
            }
            this.out.close();
        } else {
            this.flushData();
            this.zipOut.close();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.validate();
        while (len > 0) {
            int l;
            if (this.pos >= this.buf.length) {
                this.flushData();
            }
            if ((l = this.buf.length - this.pos) > len) {
                l = len;
            }
            System.arraycopy(b, off, this.buf, this.pos, l);
            off += l;
            len -= l;
            this.pos += l;
        }
    }
}

