/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataDump {
    private static final SimpleDateFormat df = new SimpleDateFormat("MMddHHmmss");

    public static File getDumpFile(Socket sock) {
        InetSocketAddress addr = (InetSocketAddress)sock.getRemoteSocketAddress();
        File path = new File("./").getAbsoluteFile();
        path = new File(path, addr.getHostName());
        return new File(path, df.format(new Date(System.currentTimeMillis())) + "_" + addr.getPort() + ".request");
    }

    public static InputStream createInputStream(Socket sock) throws IOException {
        File f = DataDump.getDumpFile(sock);
        f.getParentFile().mkdirs();
        return DataDump.createInputStream(sock.getInputStream(), new FileOutputStream(f));
    }

    public static InputStream createInputStream(InputStream in, OutputStream out) throws IOException {
        return new DumpInputStream(in, out);
    }

    private static class DumpInputStream
    extends InputStream {
        final InputStream in;
        final OutputStream out;

        DumpInputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = new BufferedOutputStream(out);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            if (r > 0) {
                try {
                    this.out.write(b, off, r);
                }
                catch (Throwable _) {
                    // empty catch block
                }
            }
            return r;
        }

        @Override
        public int read() throws IOException {
            int r = this.in.read();
            if (r != -1) {
                try {
                    this.out.write(r);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return r;
        }

        @Override
        public void close() throws IOException {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.in.close();
        }
    }
}

