/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.io.ConnectionMonitor;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DefaultConnectionMonitor
implements ConnectionMonitor {
    protected static final Logger logger = Logger.getLogger(ConnectionMonitor.class);
    public final ConnectionMonitor parent;

    public DefaultConnectionMonitor(ConnectionMonitor parent) {
        this.parent = parent;
    }

    public DefaultConnectionMonitor() {
        this(null);
    }

    @Override
    public void beforeConnect(Connector cn) throws IOException {
        if (this.parent != null) {
            this.parent.beforeConnect(cn);
        } else {
            logger.debug((Object)("try to connect '" + cn.url));
        }
    }

    @Override
    public void connectFailed(Connector cn, IOException err) throws IOException {
        if (this.parent != null) {
            this.parent.connectFailed(cn, err);
        } else {
            logger.debug((Object)("connect to '" + cn.url + "' failed(" + err.toString() + ")"));
        }
    }

    @Override
    public boolean retryConnect(Connector cn, IOException err, int retryTime) {
        if (this.parent != null) {
            return this.parent.retryConnect(cn, err, retryTime);
        }
        return retryTime < ServerManager.getConfig().connectionRetryTime;
    }

    @Override
    public void connected(Connector cn) {
        if (this.parent != null) {
            this.parent.connected(cn);
        } else {
            logger.debug((Object)(cn.url + " connected."));
        }
    }

    @Override
    public void beforeInvoke(Connector cn) {
        if (this.parent != null) {
            this.parent.beforeInvoke(cn);
        }
    }

    @Override
    public InvokeHelper newInvoke(Connector cn, InvokeHelper helper) {
        if (this.parent != null) {
            helper = this.parent.newInvoke(cn, helper);
        }
        return helper;
    }

    @Override
    public void afterInvoke(Connector cn, InvokeHelper helper) {
        if (this.parent != null) {
            this.parent.afterInvoke(cn, helper);
        }
    }
}

