/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.ServiceDispatcher;
import com.kingdee.bos.rpc.io.CCCopyStreamTimeoutMonitor;
import com.kingdee.bos.rpc.io.CompressOutputStream;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionMonitor;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.PooledSocket;
import com.kingdee.bos.rpc.io.driver.PooledTCPConnection;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class IOManager
implements InvokeHelper {
    private static final Logger logger = Logger.getLogger(IOManager.class);
    public static final int COMPRESSED = 1;
    public static final String MIN_COMPRESS_SIZE = "minCompressSize";
    public static final String ENGINE_ID = "engineId";
    public static final String LB_INDICATOR = "lbIndictor";
    private final InputStream in;
    private final OutputStream out;
    private final boolean direct;
    public final InvokeHelper helper;
    private final Connector cn;
    private boolean connectionClosed = false;
    private boolean closed = false;
    private int maxInvokeSize;

    public static Properties responseConnection(String url, Properties props) throws IOException {
        String engineId = null;
        if (props != null) {
            engineId = props.getProperty(ENGINE_ID);
        }
        if (engineId == null || engineId.length() == 0) {
            Properties resp = new Properties();
            resp.setProperty(ENGINE_ID, RPCEngine.identity);
            return resp;
        }
        if (!engineId.equalsIgnoreCase(RPCEngine.identity)) {
            throw new RPCConnectException(1005, "Server(" + url + ") restarted.", 6005);
        }
        return null;
    }

    public static Properties prepareConnection(String url, Properties props) throws IOException {
        if (props == null) {
            props = new Properties();
        }
        if (!props.containsKey(MIN_COMPRESS_SIZE)) {
            int minCompressSize = ServerManager.getConfig().minCompressSize;
            if (minCompressSize >= 0 && ServerManager.getConfig().compressOnlyRemote) {
                InetAddress addr;
                int index = url.indexOf(47) + 2;
                int index1 = url.indexOf(47, index);
                String address = index1 > 0 ? url.substring(index, index1) : url.substring(index);
                index = address.indexOf(58);
                if (index >= 0) {
                    address = address.substring(0, index);
                }
                if ((addr = InetAddress.getByName(address)).isSiteLocalAddress() || addr.isLoopbackAddress()) {
                    minCompressSize = -1;
                }
            }
            if (minCompressSize >= 0) {
                props.setProperty(MIN_COMPRESS_SIZE, Integer.toString(minCompressSize));
            }
        }
        return props;
    }

    public static InvokeHelper createInvokeHelper(Connector cn, InvokeHelper helper, boolean direct) {
        return new IOManager(cn, helper, direct);
    }

    private static void copyStream(InputStream in, OutputStream out, byte[] buf) throws IOException {
        int r;
        while ((r = in.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirect(ConnectionHelper cn, InputStream in, OutputStream out) throws IOException {
        block18: {
            OutputStream out2 = null;
            InputStream in2 = null;
            byte[] buf = new byte[ServerManager.getConfig().blockBufferSize];
            try {
                int l = in.read(buf);
                if (l <= 0) break block18;
                if (cn instanceof PooledTCPConnection) {
                    PooledTCPConnection pcn = (PooledTCPConnection)cn;
                    PooledSocket ps = pcn.getSocket();
                    Socket socket = ps.getSocket();
                    CCCopyStreamTimeoutMonitor monitor = null;
                    if (ServerManager.getConfig().monitorCopyStream) {
                        monitor = new CCCopyStreamTimeoutMonitor(pcn, socket);
                        RPCEngine.startThread(monitor);
                    }
                    try {
                        out2 = ps.getOutputStream();
                        DataOutputStream dos = new DataOutputStream(out2);
                        dos.writeShort(-32658);
                        dos.flush();
                        out2.write(buf, 0, l);
                        IOManager.copyStream(in, out2, buf);
                        out2.close();
                        in.close();
                        in2 = ps.getInputStream();
                        DataInputStream dis = new DataInputStream(in2);
                        if (ServerManager.getConfig().monitorCopyStream) {
                            socket.setSoTimeout(5000);
                        }
                        long t1 = System.currentTimeMillis();
                        try {
                            short v = dis.readShort();
                            if (v != -32657) {
                                throw new IOException("Magic Ping Result " + v + " not match." + -32657);
                            }
                        }
                        catch (IOException e) {
                            long t2 = System.currentTimeMillis();
                            logger.error((Object)("Read Ping Result Timeout :" + (t2 - t1)));
                            throw e;
                        }
                        finally {
                            socket.setSoTimeout(0);
                        }
                        IOManager.copyStream(in2, out, buf);
                        out.close();
                        in2.close();
                        break block18;
                    }
                    finally {
                        if (monitor != null) {
                            monitor.stopAndSignal();
                        }
                    }
                }
                InvokeHelper helper2 = null;
                helper2 = cn.newInvokeHelper();
                out2 = helper2.getOutputStream();
                out2.write(buf, 0, l);
                IOManager.copyStream(in, out2, buf);
                out2.close();
                in.close();
                helper2.setSocketOption();
                in2 = helper2.getInputStream();
                IOManager.copyStream(in2, out, buf);
                out.close();
                in2.close();
            }
            finally {
                if (in2 != null) {
                    IOUtil.close(in2);
                }
                if (out2 != null) {
                    IOUtil.close(out2);
                }
            }
        }
    }

    public static void startService(InvokeHelper helper, ConnectionHelper redirect) {
        if (redirect == null) {
            ConnectionHelper ch2 = (ConnectionHelper)helper.getConnection();
            ServiceDispatcher dispatcher = ((ConnectionBase)ch2).getServer().getServiceDispatcher();
            dispatcher.startService(IOManager.createInvokeHelper(null, helper, false));
        } else {
            RPCEngine.startThread(new RedirectRunner(helper, redirect));
        }
    }

    private IOManager(Connector cn, InvokeHelper helper, boolean direct) {
        this.maxInvokeSize = ServerManager.getConfig().maxInvokeDataSize;
        this.cn = cn;
        if (cn != null) {
            cn.addRef();
        }
        this.helper = helper;
        this.direct = direct;
        this.in = new Input();
        this.out = new Output();
    }

    private RPCIOException unsupportedProtocol(int p) {
        return new RPCIOException(2001, "unsupported protocol(" + p + ")");
    }

    protected int getMinCompressSize() {
        int v = IOUtil.getPropertyInt(this.getConnection().getConnectionProps(), MIN_COMPRESS_SIZE, -1);
        if (v > 0 && v < 512) {
            v = 512;
        }
        return v;
    }

    protected InputStream getFilterInputStream(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b != 0 && b != 1) {
            throw this.unsupportedProtocol(b);
        }
        if (b == 1) {
            in = new GZIPInputStream(IOUtil.limitInputStream(in, true));
        }
        return IOUtil.limitInputStream(in, false);
    }

    protected OutputStream getFilterOutputStream(OutputStream out) throws IOException {
        int minCompressSize = this.getMinCompressSize();
        if (minCompressSize < 0) {
            out.write(0);
        } else if (minCompressSize == 0) {
            out.write(1);
            out = new GZIPOutputStream(IOUtil.limitOutputStream(out, true));
        } else {
            out = new CompressOutputStream(IOUtil.limitOutputStream(out, true), minCompressSize);
        }
        return IOUtil.limitOutputStream(out, false);
    }

    private void closeConnection() {
        if (this.connectionClosed) {
            return;
        }
        this.connectionClosed = true;
        try {
            this.helper.getConnection().close();
        }
        catch (Throwable e) {
            logger.debug((Object)e, e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.helper.getConnection();
    }

    @Override
    public void close() {
        ConnectionMonitor monitor;
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.cn != null) {
            this.cn.release();
        }
        IOUtil.close(this.out);
        IOUtil.close(this.in);
        IOUtil.close(this.helper);
        if (this.cn != null && (monitor = ServerManager.getConfig().connectionMonitor) != null) {
            monitor.afterInvoke(this.cn, this);
        }
    }

    void error(Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        RPCException.throwIt(e);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    void checkDataSize(int size, boolean actual) {
        if (size > this.maxInvokeSize) {
            throw new RPCException(1006, "data size too large, the limited value is " + ServerManager.getConfig().maxInvokeDataSize);
        }
    }

    @Override
    public void setSocketOption() {
        if (this.helper != null) {
            this.helper.setSocketOption();
        }
    }

    private class Input
    extends InputStream {
        int size = 0;
        InputStream in = null;
        private final byte[] buf;
        private int pos;
        private int bufLen;
        private boolean eof = false;
        private volatile boolean closed = false;

        Input() {
            this.buf = new byte[ServerManager.getConfig().blockBufferSize];
            this.pos = 0;
            this.bufLen = 0;
        }

        private InputStream _in() throws IOException {
            if (this.in == null) {
                this.in = IOManager.this.helper.getInputStream();
                if (!IOManager.this.direct) {
                    InvokeRecord rec = InvokeRecord.getCurrent();
                    if (rec == null) {
                        this.in = IOManager.this.getFilterInputStream(this.in);
                    } else {
                        CounterInput in1 = new CounterInput(this.in, rec, 2);
                        this.in = IOManager.this.getFilterInputStream(in1);
                        if (this.in == in1) {
                            in1.type = 3;
                        } else {
                            this.in = new CounterInput(this.in, rec, 1);
                        }
                    }
                }
            }
            return this.in;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.in != null) {
                    this._in().close();
                }
            }
            catch (Throwable e) {
                IOManager.this.error(e);
            }
        }

        private int fetch() throws IOException {
            if (this.pos < this.bufLen) {
                return this.bufLen - this.pos;
            }
            if (this.eof) {
                return 0;
            }
            this.pos = 0;
            try {
                this.bufLen = this._in().read(this.buf);
            }
            catch (Throwable e) {
                IOManager.this.error(e);
            }
            if (this.bufLen <= 0) {
                this.eof = true;
                this.bufLen = 0;
            } else {
                this.size += this.bufLen;
            }
            return this.bufLen;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.fetch() == 0) {
                return -1;
            }
            return 0xFF & this.buf[this.pos++];
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int l = this.fetch();
            if (l == 0) {
                return -1;
            }
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.buf, this.pos, b, off, l);
            this.pos += l;
            return l;
        }
    }

    private class Output
    extends OutputStream {
        private int size = 0;
        private OutputStream out = null;
        private final byte[] buf;
        private int pos;
        volatile boolean closed = false;

        Output() {
            this.buf = new byte[ServerManager.getConfig().blockBufferSize];
            this.pos = 0;
        }

        private OutputStream _out() throws IOException {
            if (this.out == null) {
                this.out = IOManager.this.helper.getOutputStream();
                if (!IOManager.this.direct) {
                    InvokeRecord rec = InvokeRecord.getCurrent();
                    if (rec == null) {
                        this.out = IOManager.this.getFilterOutputStream(this.out);
                    } else {
                        rec.doOutput(0, 3);
                        CounterOutput out1 = new CounterOutput(this.out, rec, 2);
                        this.out = IOManager.this.getFilterOutputStream(out1);
                        if (this.out == out1) {
                            out1.type = 3;
                        } else {
                            this.out = new CounterOutput(this.out, rec, 1);
                        }
                    }
                }
            }
            return this.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Output output = this;
            synchronized (output) {
                if (this.pos > 0) {
                    this._flush();
                }
                try {
                    this._out().close();
                }
                catch (Throwable e) {
                    IOManager.this.error(e);
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }

        private void _flush() throws IOException {
            this.size += this.pos;
            try {
                this._out().write(this.buf, 0, this.pos);
                this.pos = 0;
            }
            catch (Throwable e) {
                IOManager.this.error(e);
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.pos >= this.buf.length) {
                this._flush();
            }
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int l;
                if (this.pos >= this.buf.length) {
                    this._flush();
                }
                if ((l = this.buf.length - this.pos) > len) {
                    l = len;
                }
                System.arraycopy(b, off, this.buf, this.pos, l);
                off += l;
                len -= l;
                this.pos += l;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }

    private class CounterOutput
    extends OutputStream {
        OutputStream out;
        InvokeRecord rec;
        int type;

        CounterOutput(OutputStream out, InvokeRecord rec, int type) {
            this.out = out;
            this.rec = rec;
            this.type = type;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.rec.doOutput(1, this.type);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.rec.doOutput(len, this.type);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private class CounterInput
    extends InputStream {
        InputStream in;
        InvokeRecord rec;
        int type;

        CounterInput(InputStream in, InvokeRecord rec, int type) {
            this.in = in;
            this.rec = rec;
            this.type = type;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                this.rec.doInput(1, this.type);
            } else {
                this.rec.doInput(-1, this.type);
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            this.rec.doInput(r, this.type);
            return r;
        }
    }

    private static class RedirectRunner
    implements Runnable {
        final InvokeHelper helper;
        final ConnectionHelper redirect;

        RedirectRunner(InvokeHelper helper, ConnectionHelper redirect) {
            this.helper = helper;
            this.redirect = redirect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                IOManager.redirect(this.redirect, this.helper.getInputStream(), this.helper.getOutputStream());
            }
            catch (Throwable e) {
                IOUtil.logIOError(logger, e);
                IOUtil.close(this.redirect);
            }
            finally {
                IOUtil.close(this.helper);
            }
        }
    }
}

