/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.StreamPipe;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class MultiChannelsConnection
extends ConnectionBase {
    private static final Logger logger = Logger.getLogger(MultiChannelsConnection.class);
    protected static final int EOF = Integer.MIN_VALUE;
    protected static final int CREATE = 0x40000000;
    protected static final int CLOSE = 0x20000000;
    protected static final int COMMAND_MASK = -536870912;
    protected static final int DATA_MASK = 0x1FFFFFFF;
    protected static final int HEADER_LENGTH = 8;
    private final HashMap channels = new HashMap();
    public final boolean isClient;
    protected Throwable closeReason = null;
    final int bufferSize;
    private final Object sendMonitor = new Object();
    private int channelIndexSeq = 1;

    public MultiChannelsConnection(String url, Properties props, boolean isClient) {
        super(url, props);
        this.isClient = isClient;
        this.bufferSize = ServerManager.getConfig().blockBufferSize;
    }

    protected abstract void send(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChannel(byte[] b, int off, int len) throws IOException {
        Object object = this.sendMonitor;
        synchronized (object) {
            this.send(b, off, len);
        }
    }

    protected boolean serviceLoop(DataInputStream in) {
        try {
            int index = in.readInt();
            int cmd = in.readInt();
            int len = cmd & 0x1FFFFFFF;
            byte[] data = null;
            boolean eof = (cmd & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            boolean create = (cmd & 0x40000000) == 0x40000000;
            boolean close = (cmd & 0x20000000) == 0x20000000;
            Channel channel = this.getChannel(index, create);
            if (channel != null) {
                if (create) {
                    this.startService(channel);
                }
                if (len > 0) {
                    int bSize = ServerManager.getConfig().blockBufferSize;
                    if (len > bSize) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssS");
                        String time = df.format(new Date(System.currentTimeMillis()));
                        String dumpFileName = "greater1024_rpc_" + time + ".dump";
                        byte[] tempBuf = new byte[bSize];
                        int length = in.read(tempBuf);
                        if (length < 0) {
                            throw new EOFException();
                        }
                        byte[] buffer = new byte[length];
                        System.arraycopy(tempBuf, 0, buffer, 0, length);
                        while (length == bSize) {
                            tempBuf = new byte[bSize];
                            length = in.read(tempBuf);
                            if (length < 0) {
                                throw new EOFException();
                            }
                            byte[] buffer1 = new byte[buffer.length + length];
                            System.arraycopy(buffer, 0, buffer1, 0, buffer.length);
                            System.arraycopy(tempBuf, 0, buffer1, buffer.length, length);
                            buffer = buffer1;
                            buffer1 = null;
                            tempBuf = null;
                        }
                        DataOutputStream dump = new DataOutputStream(new FileOutputStream(dumpFileName));
                        dump.writeInt(index);
                        dump.writeInt(cmd);
                        dump.write(buffer, 0, buffer.length);
                        dump.flush();
                        dump.close();
                        StringBuffer message = new StringBuffer(20);
                        message.append("serviceLoop meet an illgel block (>").append(bSize).append(") (len=").append(len).append(" index=").append(index).append(" cmd=").append(Integer.toHexString(cmd)).append(" client=").append(this.client).append("). close and dump it. [dumpfile=").append(new File(dumpFileName).getAbsolutePath()).append("]");
                        logger.error((Object)message.toString(), new Throwable());
                        throw new RuntimeException(message.toString());
                    }
                    data = new byte[len];
                    in.readFully(data);
                    if (data != null) {
                        channel.appendData(data);
                    }
                }
                if (eof) {
                    channel.appendData(null);
                }
                if (close) {
                    channel.peerClosed = true;
                }
            }
            return true;
        }
        catch (Throwable e) {
            IOUtil.logIOError(logger, e);
            this.close(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalClose() throws Throwable {
        Object[] chs;
        IOUtil.close(this.redirect);
        HashMap hashMap = this.channels;
        synchronized (hashMap) {
            chs = this.channels.values().toArray();
        }
        for (int i = 0; i < chs.length; ++i) {
            ((Channel)chs[i]).close();
        }
    }

    protected void close(Throwable reason) {
        if (!this.isClosed()) {
            this.closeReason = reason;
            this.close();
        }
    }

    protected void checkConnection() throws IOException {
        if (this.isClosed()) {
            if (this.closeReason != null) {
                throw new RPCIOException(2004, this.closeReason.toString());
            }
            throw new RPCIOException(2004, "Connection closed.");
        }
    }

    @Override
    public InvokeHelper newInvokeHelper() throws IOException {
        return this.createChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel createChannel() throws IOException {
        this.checkConnection();
        HashMap hashMap = this.channels;
        synchronized (hashMap) {
            int index;
            Integer key;
            do {
                ++this.channelIndexSeq;
            } while (this.channels.containsKey(key = Integer.valueOf(index)));
            Channel channel = new Channel(this, index, true);
            this.channels.put(key, channel);
            return channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int index, boolean create) {
        HashMap hashMap = this.channels;
        synchronized (hashMap) {
            if (create) {
                Channel channel = new Channel(this, index, false);
                this.channels.put(index, channel);
                return channel;
            }
            return (Channel)this.channels.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannel(int index) {
        HashMap hashMap = this.channels;
        synchronized (hashMap) {
            this.channels.remove(index);
        }
    }

    private static class Channel
    implements InvokeHelper {
        final int index;
        final MultiChannelsConnection cn;
        final StreamPipe pipe;
        final Output out;
        final InputStream in;
        final boolean isClient;
        private boolean eof = false;
        boolean peerClosed = false;
        boolean closed = false;

        Channel(MultiChannelsConnection cn, int index, boolean isClient) {
            this.isClient = isClient;
            this.cn = cn;
            this.index = index;
            this.pipe = new StreamPipe();
            this.in = this.pipe.getInputStream();
            this.out = new Output();
        }

        synchronized void appendData(byte[] data) {
            try {
                if (data == null) {
                    this.eof = true;
                    this.pipe.closeOutput();
                } else {
                    this.pipe.addData(data);
                }
            }
            catch (Throwable e) {
                RPCException.throwIt(e);
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.out;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        @Override
        public Connection getConnection() {
            return this.cn;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.cn.removeChannel(this.index);
                IOUtil.close(this.in);
                IOUtil.close(this.out);
                this.closed = true;
                try {
                    if (this.isClient && !this.eof) {
                        this.out.sendClose();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void setSocketOption() {
        }

        private class Output
        extends OutputStream {
            final byte[] buf;
            int pos;
            private volatile boolean closed = false;
            private boolean needCreate;

            Output() {
                this.buf = new byte[Channel.this.cn.bufferSize];
                IOUtil.intToBytes(Channel.this.index, this.buf, 0);
                this.needCreate = Channel.this.isClient;
                this.pos = 8;
            }

            synchronized void sendClose() {
                try {
                    IOUtil.intToBytes(0x20000000, this.buf, 4);
                    Channel.this.cn.writeChannel(this.buf, 0, 8);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            private synchronized void flush(boolean close) throws IOException {
                if (this.closed && !close) {
                    throw new RPCIOException(2003, "Stream closed.");
                }
                if (Channel.this.peerClosed) {
                    throw new RPCIOException(2008, "Peer closed.");
                }
                if (!close && this.pos < this.buf.length) {
                    return;
                }
                int dataLen = this.pos - 8;
                if (this.needCreate) {
                    this.needCreate = false;
                    dataLen |= 0x40000000;
                }
                if (close) {
                    dataLen |= Integer.MIN_VALUE;
                }
                IOUtil.intToBytes(dataLen, this.buf, 4);
                Channel.this.cn.writeChannel(this.buf, 0, this.pos);
                this.pos = 8;
            }

            @Override
            public synchronized void write(int b) throws IOException {
                this.buf[this.pos++] = (byte)b;
                this.flush(false);
            }

            @Override
            public synchronized void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                while (len > 0) {
                    int l = this.buf.length - this.pos;
                    if (l > len) {
                        l = len;
                    }
                    System.arraycopy(b, off, this.buf, this.pos, l);
                    off += l;
                    len -= l;
                    this.pos += l;
                    this.flush(false);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    this.flush(true);
                }
            }
        }
    }
}

