/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.MultiChannelsConnection;
import com.kingdee.bos.rpc.io.nio.NIOManager;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import org.apache.log4j.Logger;

public class NIOConnection
extends MultiChannelsConnection {
    private static final Logger logger = Logger.getLogger(NIOConnection.class);
    protected final _Socket sock = null;
    private final InputStream in;
    private final OutputStream out;
    private ServiceRunner serviceRunner = null;

    public NIOConnection(NIOSocket sock, String url, Properties props, boolean isClient) {
        super(url, props, isClient);
        this.sock.cn = this;
        this.in = sock.getInputStream();
        this.out = sock.getOutputStream();
    }

    @Override
    protected void send(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
            this.out.flush();
        }
        catch (Throwable e) {
            this.close(e);
            throw RPCIOException.create(e);
        }
    }

    @Override
    protected void finalClose() throws Throwable {
        super.finalClose();
        IOUtil.close(this.sock);
    }

    void startService() throws IOException {
        if (this.serviceRunner != null) {
            throw new Error("Service always started.");
        }
        this.serviceRunner = new ServiceRunner(this.in);
        NIOManager.register(this.sock);
    }

    public static NIOSocket createSocket(SocketChannel channel) throws IOException {
        return new _Socket(channel);
    }

    private static class _Socket
    extends NIOSocket {
        NIOConnection cn = null;

        _Socket(SocketChannel channel) throws IOException {
            super(channel);
        }

        @Override
        public void close() {
            if (this.cn != null) {
                this.cn.close();
            }
            super.close();
        }

        @Override
        public void notifyReadable() {
            super.notifyReadable();
            if (this.cn != null) {
                this.cn.serviceRunner.start();
            }
        }
    }

    private class ServiceRunner
    implements Runnable {
        final DataInputStream in;
        final InputStream in0;
        private boolean running = false;
        private boolean keepRunning = false;

        ServiceRunner(InputStream in) {
            this.in0 = in;
            this.in = new DataInputStream(in);
        }

        synchronized void start() {
            if (this.running) {
                this.keepRunning = true;
                return;
            }
            this.running = true;
            RPCEngine.startThread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!NIOConnection.this.isClosed()) {
                try {
                    while (this.in0.available() != 0 && NIOConnection.this.serviceLoop(this.in)) {
                    }
                }
                catch (Throwable e) {
                    IOUtil.logIOError(logger, e);
                    NIOConnection.this.close(e);
                }
                ServiceRunner serviceRunner = this;
                synchronized (serviceRunner) {
                    if (!this.keepRunning) {
                        this.running = false;
                        break;
                    }
                    this.keepRunning = false;
                }
            }
        }
    }
}

