/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.driver.PooledSocket;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.driver.SocketPool;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PooledTCPConnection
extends ConnectionBase {
    static final Logger logger = Logger.getLogger(PooledTCPConnection.class);
    public static final int BLOCK_MAGIC = 54515;
    public final boolean beClient;
    private IntValue objectCounterClientConnectionCount;

    public PooledTCPConnection(String url, Properties props, boolean beClient) throws IOException {
        super(url, props);
        this.beClient = beClient;
        if (beClient) {
            PooledSocket sock = this.getSocket();
            IOUtil.appendProperties(props, sock.props);
            this._releaseSocket(sock);
        } else {
            this.objectCounterClientConnectionCount = PerformanceManager.getIntValue("ClientConnectionCount");
            this.objectCounterClientConnectionCount.append(1);
        }
    }

    private PooledSocket _socket(RPCConnection cn) {
        return new _Socket(SocketPool.getPool(this.url), cn.sock, new DataInputStream(cn.in), new DataOutputStream(cn.out), cn.url, cn.props);
    }

    private boolean _releaseSocket(PooledSocket sock) {
        if (this.isClosed()) {
            return false;
        }
        if (this.beClient) {
            SocketPool pool = SocketPool.getPool(this.url);
            pool.add(sock);
        } else {
            this.startService(new _InvokeHelper(sock));
        }
        return true;
    }

    @Override
    protected void finalClose() throws Throwable {
        if (!this.beClient) {
            this.objectCounterClientConnectionCount.append(-1);
        }
    }

    public void startService(RPCConnection cn) {
        this.startService(new _InvokeHelper(this._socket(cn)));
    }

    public PooledSocket getSocket() throws IOException {
        return this.getSocket(false);
    }

    public PooledSocket getSocket(boolean newSocket) throws IOException {
        SocketPool pool = SocketPool.getPool(this.url);
        PooledSocket sock = pool.get();
        if (newSocket || sock == null) {
            sock = this.connect(pool);
        }
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledSocket connect(SocketPool pool) throws IOException {
        RPCConnection cn = new RPCConnection("RPC_POOL/1.0");
        SocketPool socketPool = pool;
        synchronized (socketPool) {
            pool.checkConnectTimeoutRecently();
            try {
                if (pool.getEngineId() == null) {
                    this.props.remove("engineId");
                } else {
                    this.props.setProperty("engineId", pool.getEngineId());
                }
                cn.connect0(this.url, this.props);
                pool.setEngineId(cn.props.getProperty("engineId"));
                String isByLB = cn.props.getProperty("isByLB");
                if ("true".equalsIgnoreCase(isByLB)) {
                    SocketPool.setByLB(true);
                } else {
                    SocketPool.setByLB(false);
                }
            }
            catch (Exception e) {
                if (RPCException.getErrorCode(e) == 1005 || e instanceof RPCConnectException) {
                    this.props.remove("engineId");
                    pool.setEngineId(null);
                    try {
                        cn.connect0(this.url, this.props);
                    }
                    catch (IOException ioe) {
                        pool.setConnectTimeout();
                        logger.error((Object)("Socket connect timeout:" + this.url), (Throwable)e);
                        throw ioe;
                    }
                    pool.setEngineId(cn.props.getProperty("engineId"));
                    String isByLB = cn.props.getProperty("isByLB");
                    if ("true".equalsIgnoreCase(isByLB)) {
                        SocketPool.setByLB(true);
                    } else {
                        SocketPool.setByLB(false);
                    }
                }
                pool.setConnectTimeout();
                logger.error((Object)("Socket connect timeout:" + this.url), (Throwable)e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
        }
        return this._socket(cn);
    }

    public synchronized InvokeHelper realNewInvokeHelper() throws IOException {
        SocketPool pool = SocketPool.getPool(this.url);
        PooledSocket sock = this.connect(pool);
        return new _InvokeHelper(sock);
    }

    @Override
    public synchronized InvokeHelper newInvokeHelper() throws IOException {
        return new _InvokeHelper(this.getSocket());
    }

    void logErr(Throwable e) {
        logger.error((Object)e, e);
    }

    private Connection _getConnection() {
        return this;
    }

    @Override
    protected void startService(final InvokeHelper helper) {
        RPCEngine.startThread(new Runnable(){

            @Override
            public void run() {
                try {
                    PooledTCPConnection.this.startServer1(helper);
                }
                catch (Throwable e) {
                    IOUtil.logIOError(logger, e);
                    IOUtil.close(helper);
                }
            }
        });
    }

    private void startServer1(InvokeHelper helper) throws IOException {
        helper.getInputStream().read(null, 0, 0);
        super.startService(helper);
    }

    class _InvokeHelper
    implements InvokeHelper {
        final PooledSocket sock;
        final InputStream in;
        final OutputStream out;

        _InvokeHelper(PooledSocket sock) {
            this.sock = sock;
            this.in = sock.getInputStream();
            this.out = sock.getOutputStream();
        }

        @Override
        public void close() {
            IOUtil.close(this.getOutputStream());
            IOUtil.close(this.getInputStream());
        }

        @Override
        public Connection getConnection() {
            return PooledTCPConnection.this._getConnection();
        }

        @Override
        public InputStream getInputStream() {
            return this.in;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.out;
        }

        @Override
        public void setSocketOption() {
            if (this.sock != null) {
                try {
                    this.sock.sock.setSoTimeout(0);
                }
                catch (SocketException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    class _Socket
    extends PooledSocket {
        _Socket(SocketPool pool, Socket sock, DataInputStream in, DataOutputStream out, String url, Properties props) {
            super(pool, sock, in, out, url, props);
        }

        @Override
        protected boolean releaseSocket() {
            return PooledTCPConnection.this._releaseSocket(this);
        }
    }
}

