/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.driver.PooledTCPConnectionDriver;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.ssl.SSLSecurityProivder;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;

public class SSLTCPDriver
extends PooledTCPConnectionDriver {
    public static final String PROTOCOL = "tcps";
    public static final String URL_PREFIX = "tcps://";
    private static final Logger logger = Logger.getLogger(SSLTCPDriver.class);

    public SSLTCPDriver() {
        super(PROTOCOL);
    }

    public static Socket connect(InetSocketAddress addr) throws IOException {
        try {
            SSLSecurityProivder provider = SSLSecurityProivder.getRPCSSLSecurityProivder();
            SSLContext ctx = provider.getClientContext();
            Socket sock = ctx.getSocketFactory().createSocket(addr.getAddress(), addr.getPort());
            sock.setSoTimeout(ServerManager.getConfig().sslHandshakeTimeout);
            if (sock instanceof SSLSocket) {
                SSLSocket sc2 = (SSLSocket)sock;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("UseClientMode:" + sc2.getUseClientMode()));
                }
                sc2.setUseClientMode(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("EnabledCipherSuites:" + StringUtils.arrayToString((Object[])sc2.getEnabledCipherSuites(), (String)",")));
                    logger.debug((Object)("NeedClientAuth:" + sc2.getNeedClientAuth()));
                    logger.debug((Object)("SupportedCipherSuites:" + StringUtils.arrayToString((Object[])sc2.getSupportedCipherSuites(), (String)",")));
                }
            }
            return sock;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RPCException.createIt(e);
        }
    }

    static {
        ConnectionManager.registerDriver(new SSLTCPDriver());
    }
}

