/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.RPCMonitor;
import com.kingdee.bos.rpc.io.driver.PooledSocket;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class SocketPool {
    static final Logger logger = Logger.getLogger(SocketPool.class);
    public final String url;
    private final ArrayList pool = new ArrayList();
    private final IntValue poolCounter;
    private String engineId;
    private volatile long lastConnectTimeout = -1L;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static HashMap pools = new HashMap();
    private static boolean isByLB = false;

    SocketPool(String url) {
        this.url = url;
        this.poolCounter = PerformanceManager.getIntValue("PooledSocket." + url + "(idle)");
        RPCMonitor.addMonitor(new Runnable(){

            @Override
            public void run() {
                SocketPool.this.checkSocketPool();
            }
        });
    }

    public void setConnectTimeout() {
        this.lastConnectTimeout = System.currentTimeMillis();
    }

    public boolean isConnectTimeoutRecently() {
        return System.currentTimeMillis() - this.lastConnectTimeout < 8000L;
    }

    public void checkConnectTimeoutRecently() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkSocketPool() {
        int i;
        RPCConfig conf = ServerManager.getConfig();
        int poolsize = 0;
        try {
            this.rwl.readLock().lock();
            poolsize = this.pool.size();
        }
        finally {
            this.rwl.readLock().unlock();
        }
        HashMap<PooledSocket, String> removeLs = new HashMap<PooledSocket, String>();
        for (i = 0; i < poolsize; ++i) {
            PooledSocket sock = null;
            try {
                this.rwl.writeLock().lock();
                if (i >= this.pool.size()) break;
                sock = (PooledSocket)this.pool.get(i);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
            boolean bclose = false;
            try {
                sock.test(false);
            }
            catch (Exception ex) {
                IOUtil.logIOError(logger, ex);
                bclose = true;
            }
            long idleTime = sock.getIdleTime();
            if (conf.socketPoolSize == 0) {
                if (poolsize > 1 && idleTime > (long)conf.exceedPoolSocketTimeout) {
                    bclose = true;
                } else if (idleTime > (long)conf.defaultSocketTimeout) {
                    bclose = true;
                }
            } else if (poolsize > conf.socketPoolSize && idleTime > (long)conf.exceedPoolSocketTimeout) {
                bclose = true;
            } else if (poolsize <= conf.socketPoolSize && idleTime > (long)conf.defaultSocketTimeout) {
                bclose = true;
            }
            if (!bclose) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Socket idle timeout " + this.url));
            }
            sock.close();
            try {
                this.rwl.writeLock().lock();
                poolsize = this.pool.size();
                this.poolCounter.setValue(poolsize);
                removeLs.put(sock, "");
                continue;
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        if (removeLs.size() > 0) {
            try {
                this.rwl.writeLock().lock();
                i = 0;
                while (i < this.pool.size()) {
                    if (removeLs.containsKey(this.pool.get(i))) {
                        this.pool.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PooledSocket sock) {
        try {
            this.rwl.writeLock().lock();
            this.pool.add(sock);
            this.poolCounter.setValue(this.pool.size());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledSocket get() throws IOException {
        RPCConfig rpcConfig = ServerManager.getConfig();
        if (rpcConfig.monitorCopyStream) {
            this.checkConnectTimeoutRecently();
        }
        PooledSocket sock = null;
        int poolsize = 0;
        try {
            this.rwl.readLock().lock();
            poolsize = this.pool.size();
        }
        finally {
            this.rwl.readLock().unlock();
        }
        while (poolsize > 0 && sock == null) {
            try {
                this.rwl.writeLock().lock();
                try {
                    sock = (PooledSocket)this.pool.remove(this.pool.size() - 1);
                }
                catch (Exception e) {
                    this.poolCounter.setValue(this.pool.size());
                    PooledSocket pooledSocket = null;
                    this.rwl.writeLock().unlock();
                    return pooledSocket;
                }
                poolsize = this.pool.size();
                this.poolCounter.setValue(this.pool.size());
            }
            finally {
                this.rwl.writeLock().unlock();
            }
            if (!rpcConfig.testSocketBeforeUse) continue;
            try {
                sock.test(true);
            }
            catch (IOException ioe) {
                sock.close();
                sock = null;
            }
        }
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.rwl.readLock().lock();
            int n = this.pool.size();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.rwl.writeLock().lock();
            for (int i = 0; i < this.pool.size(); ++i) {
                PooledSocket sock = (PooledSocket)this.pool.get(i);
                sock.close();
            }
            this.pool.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.poolCounter.setValue(0);
    }

    public static synchronized SocketPool getPool(String url) {
        SocketPool pool = (SocketPool)pools.get(url);
        if (pool == null) {
            pool = new SocketPool(url);
            pools.put(url, pool);
        }
        return pool;
    }

    public synchronized String getEngineId() {
        return this.engineId;
    }

    public synchronized void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public static boolean isByLB() {
        return isByLB;
    }

    public static void setByLB(boolean isByLB) {
        SocketPool.isByLB = isByLB;
    }
}

