/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.rpc.io.loadbalance.RPCServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import com.kingdee.bos.rpc.performance.StringPerformanceValue;

public class DefaultRPCServer
extends RPCServer {
    private float performanceFactor;
    protected final PerformanceValue perfFactor;
    protected final PerformanceValue performance;

    public DefaultRPCServer(String url, float performanceFactor, String standbyUrl, String name) {
        super(url, standbyUrl, name);
        this.performanceFactor = performanceFactor;
        this.perfFactor = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "PerformanceFactor"){

            @Override
            public Object value() {
                return String.valueOf(DefaultRPCServer.this.performanceFactor);
            }
        };
        PerformanceManager.setValue(this.perfFactor);
        this.performance = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "Performance"){

            @Override
            public Object value() {
                return String.valueOf(DefaultRPCServer.this.getPerformance());
            }
        };
        PerformanceManager.setValue(this.performance);
    }

    public DefaultRPCServer(String url, float performanceFactor) {
        this(url, performanceFactor, null, null);
    }

    public DefaultRPCServer(String url) {
        this(url, 1.0f, null, null);
    }

    protected float getFailTime() {
        if (!super.connectionFailed()) {
            return 0.0f;
        }
        long t = ServerManager.getConfig().loadbalanceConnectionRetryTime - (System.currentTimeMillis() - this.getLastConnectTime());
        if (t < 0L) {
            t = 0L;
        }
        return t;
    }

    @Override
    public synchronized float getPerformance() {
        return this.performanceFactor / (float)(this.getConnectionCount() + 1);
    }

    public int compareTo(Object x) {
        DefaultRPCServer s2 = (DefaultRPCServer)x;
        int r = Float.compare(this.getFailTime(), s2.getFailTime());
        if (r != 0) {
            return r;
        }
        float f2 = s2.getPerformance();
        float f1 = this.getPerformance();
        return Float.compare(f2, f1);
    }

    @Override
    public void stop() {
        super.stop();
        PerformanceManager.removeValue(this.perfFactor);
        PerformanceManager.removeValue(this.performance);
    }

    @Override
    public synchronized float getPerformanceFactor() {
        return this.performanceFactor;
    }

    public synchronized void setPerformanceFactor(float performanceFactor) {
        this.performanceFactor = performanceFactor;
    }

    @Override
    public float getHealthDegree() {
        return 0.0f;
    }
}

