/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.rpc.io.loadbalance.LBListener;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LBListenerManager {
    private static Logger logger = Logger.getLogger(LBListenerManager.class);
    private static List lbListeners = new ArrayList();

    private static void init() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("lbListeners");
        if (ci == null) {
            logger.info((Object)"Can't find lbListeners configItem");
            return;
        }
        Map map = ci.getProperties();
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                LBListener lis = (LBListener)c.newInstance();
                lbListeners.add(lis);
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    public static synchronized void registerListener(LBListener listener) {
        lbListeners.add(listener);
    }

    public static synchronized void unregisterListener(LBListener listener) {
        lbListeners.remove(listener);
    }

    public static synchronized void broadcast(RPCServerView sv) {
        for (LBListener listener : lbListeners) {
            if (listener == null) continue;
            listener.stateChange(sv);
        }
    }

    static {
        try {
            LBListenerManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

