/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class LBServerStat {
    private static final Logger logger = Logger.getLogger(LBServerStat.class);
    String url;
    String ip;
    int lbMonPort;
    float performanceFactor = 0.0f;
    int connectionCount = 0;
    public static final float DEFAULTDYNAMICEFFECT = 0.2f;
    private float dynamicEffect = 0.2f;
    private Object lock = new Object();
    long retryTime = 60000L;
    private float pingInterval = 10000.0f;
    private boolean remotePingFailed;
    private long lastRemotePingTime;
    private float healthDegree;

    LBServerStat(String url, float performanceFactor) {
        this.url = url;
        this.performanceFactor = performanceFactor;
    }

    LBServerStat(String url, float performanceFactor, float dynamicEffect, int rmiPort) {
        this.url = url;
        this.setDynamicEffect(dynamicEffect);
        this.ip = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
        this.performanceFactor = performanceFactor;
        Thread t = new Thread((Runnable)new FactorTester(this.ip, rmiPort), "dynamicFactorRetriever[" + url + "]");
        t.setDaemon(true);
        t.start();
        logger.info((Object)("DynamicFactorRetriever Thread for " + url + " started!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getPerformance() {
        Object object = this.lock;
        synchronized (object) {
            return this.performanceFactor / (float)(this.connectionCount + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getDynamicPerformance() {
        Object object = this.lock;
        synchronized (object) {
            return this.performanceFactor * (1.0f + this.dynamicEffect * this.healthDegree) / (float)(this.connectionCount + 1);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof LBServerStat) {
            return this.url.equalsIgnoreCase(((LBServerStat)o).url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.toLowerCase().hashCode();
    }

    protected synchronized void success() {
        this.remotePingFailed = false;
        this.lastRemotePingTime = System.currentTimeMillis();
    }

    protected synchronized void failed() {
        this.remotePingFailed = true;
        this.healthDegree = -1.0f;
        this.lastRemotePingTime = System.currentTimeMillis();
    }

    synchronized boolean isRemotePingFailed() {
        return this.remotePingFailed;
    }

    public float getDynamicEffect() {
        return this.dynamicEffect;
    }

    public void setDynamicEffect(float dynamicEffect) {
        if (dynamicEffect >= 0.0f && dynamicEffect <= 1.0f) {
            this.dynamicEffect = dynamicEffect;
        }
    }

    static class LBManageClient {
        private MBeanServerConnection serverConn;
        private ObjectName lbManage = null;
        private String ipPort;

        public LBManageClient(String ip, int rmiPort) {
            this.ipPort = ip + ":" + rmiPort;
        }

        private void connectClusterControl() throws Exception {
            logger.info((Object)"Connect it to the RMI connector server");
            String strUrl = "service:jmx:rmi:///jndi/rmi://" + this.ipPort + "/bos";
            logger.info((Object)("JMXServiceURL=" + strUrl));
            try {
                if (this.serverConn == null) {
                    JMXServiceURL url = new JMXServiceURL(strUrl);
                    JMXConnector jmxc = JMXConnectorFactory.connect(url);
                    this.serverConn = jmxc.getMBeanServerConnection();
                }
            }
            catch (Exception ex) {
                throw new Exception("Jmx can't connect to " + this.ipPort);
            }
            try {
                ObjectName queryName;
                Set<ObjectName> s;
                Iterator<ObjectName> iter;
                if (this.lbManage == null && (iter = (s = this.serverConn.queryNames(queryName = new ObjectName(this.serverConn.getDefaultDomain() + ":type=LBManage,*"), null)).iterator()).hasNext()) {
                    this.lbManage = iter.next();
                }
            }
            catch (Exception ex) {
                throw new Exception("Get LB MBean error");
            }
        }

        public String[] getHdAndTcc() throws Exception {
            if (this.serverConn == null || this.lbManage == null) {
                this.connectClusterControl();
            }
            return (String[])this.serverConn.invoke(this.lbManage, "getHdAndTcc", new Object[0], new String[0]);
        }
    }

    class FactorTester
    implements Runnable {
        private LBManageClient mc;

        FactorTester(String ip, int rmiPort) {
            this.mc = new LBManageClient(ip, rmiPort);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep((long)LBServerStat.this.pingInterval);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (LBServerStat.this.remotePingFailed && System.currentTimeMillis() - LBServerStat.this.lastRemotePingTime < LBServerStat.this.retryTime) continue;
                this.getHealthDegree();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getHealthDegree() {
            try {
                String[] ht = this.mc.getHdAndTcc();
                LBServerStat.this.healthDegree = Float.parseFloat(ht[0]);
                Object object = LBServerStat.this.lock;
                synchronized (object) {
                    LBServerStat.this.connectionCount = Integer.parseInt(ht[1]);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LBServerStat.this.url + " connectionCount=" + LBServerStat.this.connectionCount + " ; healthDegree=" + LBServerStat.this.healthDegree));
                }
                LBServerStat.this.success();
            }
            catch (Exception e) {
                logger.error((Object)"getHealthDegree failed!", (Throwable)e);
                LBServerStat.this.failed();
            }
        }
    }
}

