/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.io.ConnectionFactory;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.loadbalance.DefaultRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.DynamicFactorRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import com.kingdee.bos.rpc.performance.StringPerformanceValue;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class LoadBalance
extends ConnectionFactory {
    private static final Logger logger = Logger.getLogger(LoadBalance.class);
    public static final String LOADBALANCE = "loadbalance";
    public static final String IS_BY_LB = "isByLB";
    public static boolean working = false;
    public final PerformanceValue hd = new StringPerformanceValue("[LoadBalance]HealthDegree"){

        @Override
        public Object value() {
            return String.valueOf(LoadBalance.this.getHealthDegree());
        }
    };
    public final PerformanceValue workingPV = new StringPerformanceValue("[LoadBalance]isWorking"){

        @Override
        public Object value() {
            return String.valueOf(working);
        }
    };
    private final ArrayList<RPCServer> servers = new ArrayList();

    public LoadBalance(String name) {
        super(name);
        PerformanceManager.setValue(this.hd);
        PerformanceManager.setValue(this.workingPV);
    }

    public LoadBalance(String name, RPCServer[] servers) {
        this(name);
        for (int i = 0; i < servers.length; ++i) {
            servers[i].setLoadBalance(this);
            this.servers.add(servers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServer(RPCServer server) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            server.setLoadBalance(this);
            this.servers.add(server);
        }
        logger.info((Object)("LB register server [" + server.getName() + "]"));
    }

    public void registerServer(String url, float performanceFactor) {
        if (ServerManager.getConfig((String)LOADBALANCE).dynamicFactor) {
            this.registerServer(new DynamicFactorRPCServer(url, performanceFactor));
        } else {
            this.registerServer(new DefaultRPCServer(url, performanceFactor));
        }
    }

    public void registerServer(String url, float performanceFactor, String standbyUrl, String name) {
        this.registerServer(url, performanceFactor, standbyUrl, 0.2f, 10000, name);
    }

    public void registerServer(String url, float performanceFactor, String standbyUrl, float dynamicEffect, int sockTimeout, String name) {
        if (ServerManager.getConfig((String)LOADBALANCE).dynamicFactor) {
            this.registerServer(new DynamicFactorRPCServer(url, performanceFactor, standbyUrl, dynamicEffect, sockTimeout, name));
        } else {
            this.registerServer(new DefaultRPCServer(url, performanceFactor, standbyUrl, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPCServer[] getServers() {
        Object[] ss;
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            ss = this.servers.toArray(new RPCServer[this.servers.size()]);
            Arrays.sort(ss);
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPCServer[] getServersOriginOrder() {
        RPCServer[] ss;
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            ss = this.servers.toArray(new RPCServer[this.servers.size()]);
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPCServer getServer(String engine_id) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            for (int i = 0; i < this.servers.size(); ++i) {
                RPCServer server = this.servers.get(i);
                String id = server.getEngineId();
                if (id == null || !id.equals(engine_id)) continue;
                return server;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPCServer getServerByUrl(String server_url) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            for (int i = 0; i < this.servers.size(); ++i) {
                RPCServer server = this.servers.get(i);
                String url = server.getUrl();
                if (url == null || !url.equals(server_url)) continue;
                return server;
            }
        }
        return null;
    }

    @Override
    public ConnectionHelper connect(Properties props) throws IOException {
        String lbIndictor;
        String engine_id;
        if (props == null) {
            props = new Properties();
        }
        props.setProperty(IS_BY_LB, "true");
        String string = engine_id = props == null ? null : props.getProperty("engineId");
        if (engine_id != null && engine_id.trim().length() == 0) {
            engine_id = null;
        }
        RPCServer[] ss = this.getServers();
        if (engine_id != null) {
            RPCServer server = this.getServer(engine_id);
            if (server == null) {
                throw new RPCConnectException(1005, "Server has been shutdown or restarted.", 6003);
            }
            ConnectionHelper ch2 = server.connect(props);
            int cct = this.getConnectionCount(ss);
            logger.info((Object)("[" + props.getProperty("route", "") + "]LoadBalance direct dispatch to RPCServer(" + server.getUrl() + ")by EngineID [" + this.serverDec(server) + ",TCC=" + cct + "]"));
            return ch2;
        }
        String string2 = lbIndictor = props == null ? null : props.getProperty("lbIndictor");
        if (lbIndictor != null && lbIndictor.trim().length() == 0) {
            lbIndictor = null;
        }
        if (lbIndictor != null) {
            RPCServer server = this.getServerByUrl(lbIndictor);
            if (server == null) {
                throw new RPCConnectException(1005, "Server has been shutdown or restarted.", 6004);
            }
            ConnectionHelper ch3 = server.connect(props);
            int cct = this.getConnectionCount(ss);
            logger.info((Object)("[" + props.getProperty("route", "") + "]LoadBalance direct dispatch to RPCServer(" + server.getUrl() + ")by lbIndictor [" + this.serverDec(server) + ",TCC=" + cct + "]"));
            return ch3;
        }
        for (int i = 0; i < ss.length; ++i) {
            try {
                if (ss[i].getPerformanceFactor() == 0.0f) continue;
                int cct = this.getConnectionCount(ss);
                logger.info((Object)("[" + props.getProperty("route", "") + "]LoadBalance test connection to RPCServer(" + ss[i].getUrl() + ")[" + this.serverDec(ss[i]) + ",TCC=" + cct + "]"));
                ConnectionHelper ch4 = ss[i].connect(props);
                logger.info((Object)("[" + props.getProperty("route", "") + "]LoadBalance dispatch connection to RPCServer(" + ss[i].getUrl() + ")"));
                return ch4;
            }
            catch (IOException e) {
                if (!ServerManager.getConfig((String)LOADBALANCE).logIOExceptions) continue;
                logger.info((Object)e, (Throwable)e);
            }
        }
        throw new RPCIOException(4001, "no available server for '" + this.name + "'");
    }

    private String serverDec(RPCServer server) {
        StringBuffer sb = new StringBuffer();
        if (server instanceof DefaultRPCServer) {
            DefaultRPCServer ds = (DefaultRPCServer)server;
            sb.append("PerformanceFactor=").append(ds.getPerformanceFactor()).append(",Performance=").append(ds.getPerformance());
            if (server instanceof DynamicFactorRPCServer) {
                sb.append(",HealthDegree=").append(((DynamicFactorRPCServer)ds).getHealthDegree());
            }
        }
        String lct = RPCServer.format.format(new Date(server.getLastConnectTime()));
        if (server.getLastConnectTime() == 0L) {
            lct = "N/A";
        }
        sb.append(",ConnectionCount=").append(server.getConnectionCount()).append(",ConnectionFailed=").append(server.connectionFailed()).append(",LastConnectTime=").append(lct);
        return sb.toString();
    }

    private int getConnectionCount(RPCServer[] servers) {
        int cnCount = 0;
        for (int i = 0; i < servers.length; ++i) {
            cnCount += servers[i].getConnectionCount();
        }
        return cnCount;
    }

    public Map statistics() {
        System.gc();
        TreeMap<String, String> stat = new TreeMap<String, String>();
        RPCServer[] ss = this.getServersOriginOrder();
        int tcc = this.getConnectionCount(ss);
        stat.put("TCC", Integer.toString(tcc));
        stat.put("SC", Integer.toString(ss.length));
        for (int i = 0; i < ss.length; ++i) {
            RPCServer server = ss[i];
            String serverPrefix = "SERVER." + i + ".";
            stat.put(serverPrefix + "URL", server.getUrl());
            if (ss[i] instanceof DefaultRPCServer) {
                DefaultRPCServer ds = (DefaultRPCServer)server;
                stat.put(serverPrefix + "PF", String.valueOf(ds.getPerformanceFactor()));
                stat.put(serverPrefix + "P", String.valueOf(ds.getPerformance()));
            }
            String lct = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date(server.getLastConnectTime()));
            if (server.getLastConnectTime() == 0L) {
                lct = "N/A";
            }
            stat.put(serverPrefix + "LCT", lct);
            stat.put(serverPrefix + "CC", String.valueOf(server.getConnectionCount()));
            stat.put(serverPrefix + "CF", String.valueOf(server.connectionFailed()));
            if (!(ss[i] instanceof DynamicFactorRPCServer)) continue;
            stat.put(serverPrefix + "HD", String.valueOf(((DynamicFactorRPCServer)ss[i]).getHealthDegree()));
        }
        stat.put("HealthDegree", String.valueOf(this.getHealthDegree()));
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServer(int i) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            if (i >= 0 && i < this.servers.size()) {
                this.servers.remove(i);
                this.broadcast();
            }
        }
        logger.info((Object)("LB register server. index[" + i + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServer(String url) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            Iterator<RPCServer> iterator = this.servers.iterator();
            while (iterator.hasNext()) {
                RPCServer s = iterator.next();
                if (!url.equalsIgnoreCase(s.getInitUrl()) && !url.equalsIgnoreCase(s.getInitStandbyUrl())) continue;
                iterator.remove();
                s.stop();
                break;
            }
            this.broadcast();
        }
        logger.info((Object)("LB register server. url[" + url + "]"));
    }

    public float getHealthDegree() {
        RPCServer[] ss = this.getServers();
        float t = 0.0f;
        int c = 0;
        for (int i = 0; i < ss.length; ++i) {
            if (!(ss[i] instanceof DynamicFactorRPCServer)) continue;
            t += ((DynamicFactorRPCServer)ss[i]).getHealthDegree() * ((DefaultRPCServer)ss[i]).getPerformanceFactor();
            ++c;
        }
        if (c == 0) {
            return 0.0f;
        }
        return t / (float)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerformanceFactor(String url, float performanceFactor) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            for (RPCServer s : this.servers) {
                if (!url.equalsIgnoreCase(s.getInitUrl()) && !url.equalsIgnoreCase(s.getInitStandbyUrl()) || !(s instanceof DefaultRPCServer)) continue;
                ((DefaultRPCServer)s).setPerformanceFactor(performanceFactor);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSockTimeout(String url, int sockTimeout) {
        ArrayList<RPCServer> arrayList = this.servers;
        synchronized (arrayList) {
            for (RPCServer s : this.servers) {
                if (!url.equalsIgnoreCase(s.getInitUrl()) && !url.equalsIgnoreCase(s.getInitStandbyUrl()) || !(s instanceof DynamicFactorRPCServer)) continue;
                ((DynamicFactorRPCServer)s).setSockTimeout(sockTimeout);
                break;
            }
        }
    }

    public void broadcast() {
        RPCServer[] ss = this.getServersOriginOrder();
        for (int i = 0; i < ss.length; ++i) {
            ss[i].broadcast();
        }
    }
}

