/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServer;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class RPCServerView
implements IMarshalObject {
    private IRPCServer[] servers;
    private static IRPCServer lastMinPf;
    private long time;
    private static volatile RPCServerView last;

    public RPCServerView() {
        this.time = System.currentTimeMillis();
    }

    public RPCServerView(IRPCServer[] servers) throws IOException {
        this.servers = RPCServerMirror.create(servers);
        this.time = System.currentTimeMillis();
    }

    public IRPCServer[] getServers() {
        return this.servers;
    }

    public void setServers(IRPCServer[] servers) throws IOException {
        this.servers = RPCServerMirror.create(servers);
    }

    public IRPCServer getBestServer() {
        if (this.servers != null && this.servers.length > 0) {
            return this.servers[0];
        }
        return null;
    }

    public IRPCServer getBestHealthDegreeServer() {
        if (this.servers == null || this.servers.length == 0) {
            return null;
        }
        int j = 0;
        float hd = this.servers[0].getHealthDegree();
        for (int i = 1; i < this.servers.length; ++i) {
            if (!(this.servers[i].getHealthDegree() > hd) || this.servers[i].connectionFailed()) continue;
            j = i;
        }
        return this.servers[j];
    }

    public IRPCServer getMinPerformanceFactorServer() {
        if (this.servers == null || this.servers.length == 0) {
            return null;
        }
        int j = 0;
        float pf = this.servers[0].getPerformanceFactor();
        for (int i = 1; i < this.servers.length; ++i) {
            if (this.servers[i].getPerformanceFactor() < pf && !this.servers[i].connectionFailed()) {
                j = i;
                continue;
            }
            if (this.servers[i].getPerformanceFactor() != pf || this.servers[i].connectionFailed() || lastMinPf == null || !this.servers[i].getUrl().equals(lastMinPf.getUrl())) continue;
            j = i;
        }
        lastMinPf = this.servers[j];
        return this.servers[j];
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.servers);
        marshaller.writeLong(this.time);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.servers = (IRPCServer[])unmarshaller.readObject();
        this.time = unmarshaller.readLong();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public static RPCServerView getLast() {
        return last;
    }

    public static void setLast(RPCServerView sv) {
        last = sv;
    }

    public IRPCServer getServerByEngineId(String engineId) {
        if (engineId == null || this.servers == null) {
            return null;
        }
        for (int i = 0; i < this.servers.length; ++i) {
            if (!engineId.equalsIgnoreCase(this.servers[i].getEngineId())) continue;
            return this.servers[i];
        }
        return null;
    }

    public long getTime() {
        return this.time;
    }

    static {
        last = null;
    }

    public static class RPCServerMirror
    implements IRPCServer,
    IMarshalObject,
    Comparable {
        private String url = null;
        private String name = null;
        private String engine_id = null;
        private float performanceFactor = 0.0f;
        private float performance = 0.0f;
        private float healthDegree = 0.0f;
        private int connectionCount = 0;
        private boolean connectFailed = false;

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getEngineId() {
            return this.engine_id;
        }

        @Override
        public float getPerformanceFactor() {
            return this.performanceFactor;
        }

        @Override
        public float getPerformance() {
            return this.performance;
        }

        @Override
        public float getHealthDegree() {
            return this.healthDegree;
        }

        @Override
        public int getConnectionCount() {
            return this.connectionCount;
        }

        @Override
        public boolean connectionFailed() {
            return this.connectFailed;
        }

        public void marshal(Marshaller marshaller) throws IOException {
            marshaller.writeObject((Object)this.url);
            marshaller.writeObject((Object)this.name);
            marshaller.writeObject((Object)this.engine_id);
            marshaller.writeFloat(this.performanceFactor);
            marshaller.writeFloat(this.performance);
            marshaller.writeFloat(this.healthDegree);
            marshaller.writeInt(this.connectionCount);
            marshaller.writeBoolean(this.connectFailed);
        }

        public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            this.url = (String)unmarshaller.readObject();
            this.name = (String)unmarshaller.readObject();
            this.engine_id = (String)unmarshaller.readObject();
            this.performanceFactor = unmarshaller.readFloat();
            this.performance = unmarshaller.readFloat();
            this.healthDegree = unmarshaller.readFloat();
            this.connectionCount = unmarshaller.readInt();
            this.connectFailed = unmarshaller.readBoolean();
        }

        public String toString() {
            return "RPCServer [url=" + this.url + ", name=" + this.name + "]";
        }

        public int compareTo(Object o) {
            float f2 = ((IRPCServer)o).getPerformance();
            float f1 = this.getPerformance();
            return Float.compare(f2, f1);
        }

        public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
        }

        public final void writeExternal(ObjectOutput out) throws IOException {
            new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
        }

        public static RPCServerMirror[] create(IRPCServer[] servers) throws IOException {
            if (servers == null) {
                return null;
            }
            RPCServerMirror[] mirrors = new RPCServerMirror[servers.length];
            for (int i = 0; i < servers.length; ++i) {
                mirrors[i] = new RPCServerMirror();
                mirrors[i].url = servers[i].getUrl();
                mirrors[i].name = servers[i].getName();
                mirrors[i].engine_id = servers[i].getEngineId();
                mirrors[i].performanceFactor = servers[i].getPerformanceFactor();
                mirrors[i].performance = servers[i].getPerformance();
                mirrors[i].performanceFactor = servers[i].getPerformanceFactor();
                mirrors[i].connectionCount = servers[i].getConnectionCount();
                mirrors[i].connectFailed = servers[i].connectionFailed();
                if (mirrors[i].engine_id != null || mirrors[i].connectFailed || !(servers[i] instanceof RPCServer)) continue;
                ((RPCServer)servers[i]).connect(new Properties());
                mirrors[i].engine_id = servers[i].getEngineId();
            }
            return mirrors;
        }
    }
}

