/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.nio;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.nio.NIOSelector;
import com.kingdee.bos.rpc.io.nio.NIOSocketInput;
import com.kingdee.bos.rpc.io.nio.NIOSocketOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class NIOSocket {
    public final SocketChannel channel;
    private final NIOSocketInput in;
    private final NIOSocketOutput out;
    private SelectionKey selectionKey = null;
    private NIOSelector selector = null;
    private boolean closed = false;

    public NIOSocket(SocketChannel channel) throws IOException {
        this.channel = channel;
        this.in = new NIOSocketInput(this);
        this.out = new NIOSocketOutput(this);
    }

    public boolean isBlockingMode() throws IOException {
        return this.channel.isBlocking();
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public SocketChannel channel() {
        return this.channel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public NIOSelector getSelector() {
        return this.selector;
    }

    synchronized void register(NIOSelector selector) throws IOException {
        this.selector = selector;
        this.selectionKey = this.channel.register(selector.selector, 1, this);
        this.notify();
    }

    synchronized void waitForRegister() throws IOException {
        try {
            if (this.selector == null) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            RPCException.throwIt(e);
        }
    }

    protected void notifyWritable() {
        this.out.notifyWritable();
    }

    protected void notifyReadable() {
        this.in.notifyReadable();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        NIOSocket nIOSocket = this;
        synchronized (nIOSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        IOUtil.close(this.in);
        IOUtil.close(this.out);
        if (this.selector == null) {
            this.finalClose();
        } else {
            this.selector.cancel(this);
        }
    }

    void finalClose() {
        IOUtil.close(this.channel);
        IOUtil.close(this.channel.socket());
        IOUtil.close(this.selectionKey);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

