/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.nio;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.nio.NIOSelector;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;

class NIOSocketInput
extends InputStream {
    private final NIOSocket sock;
    private final LinkedList buffers = new LinkedList();
    private ByteBuffer readBuffer = null;
    private boolean closed = false;
    private boolean eof = false;
    private final int maxSize;
    private int size = 0;
    private Throwable readErr = null;

    public NIOSocketInput(NIOSocket sock) throws IOException {
        this.sock = sock;
        this.maxSize = sock.socket().getReceiveBufferSize();
    }

    private ByteBuffer allocateBuffer() {
        return NIOSelector.allocateBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        NIOSocketInput nIOSocketInput = this;
        synchronized (nIOSocketInput) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.sock.socket().shutdownInput();
            this.notify();
        }
    }

    private void validate() throws IOException {
        if (this.closed) {
            if (this.readErr != null) {
                throw new RPCIOException(2003, "Stream closed.(" + this.readErr.toString() + ")");
            }
            throw new RPCIOException(2003, "Stream closed.");
        }
    }

    @Override
    public synchronized int available() throws IOException {
        this.validate();
        if (this.size > 0) {
            return this.size;
        }
        if (this.eof) {
            return -1;
        }
        if (this.sock.getSelectionKey() == null) {
            return 0;
        }
        return this.readChannel(false);
    }

    private int availableForRead() throws IOException {
        this.validate();
        while (!this.eof && this.size == 0 && this.readChannel(false) <= 0 && !this.eof) {
            try {
                long timeout = ServerManager.getConfig().nioWaitTimeout;
                if (timeout >= 0L) {
                    this.wait(timeout);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException e) {
                RPCException.throwIt(e);
            }
        }
        if (this.size == 0) {
            return -1;
        }
        return this.size;
    }

    private ByteBuffer getReadBuffer() {
        if (this.readBuffer == null || this.readBuffer.remaining() == 0) {
            this.readBuffer = (ByteBuffer)this.buffers.removeFirst();
            this.readBuffer.flip();
        }
        return this.readBuffer;
    }

    private void bytesReaded(int count) throws IOException {
        if (this.size == 0 && !this.sock.isBlockingMode()) {
            this.readChannel(true);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        int l = this.availableForRead();
        if (l < 0) {
            return -1;
        }
        --this.size;
        int r = 0xFF & this.getReadBuffer().get();
        this.bytesReaded(1);
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int curSize = this.availableForRead();
        if (curSize < 0) {
            return -1;
        }
        if (len > curSize) {
            len = curSize;
        }
        int r = len;
        while (len > 0) {
            ByteBuffer buf = this.getReadBuffer();
            int l = buf.remaining();
            if (l > len) {
                l = len;
            }
            buf.get(b, off, l);
            off += l;
            len -= l;
            this.size -= l;
        }
        this.bytesReaded(r);
        return r;
    }

    synchronized void notifyReadable() {
        NIOSelector.selectRead(this.sock.getSelectionKey(), false, false);
        if (this.closed || this.eof) {
            this.notify();
            return;
        }
        try {
            int lastSize = this.size;
            if (lastSize != this.readChannel(false)) {
                this.notify();
            }
        }
        catch (Throwable e) {
            this.readErr = e;
            IOUtil.close(this);
        }
    }

    private int readChannel(boolean needWakeup) throws IOException {
        if (this.eof || this.size >= this.maxSize) {
            return this.size;
        }
        SocketChannel channel = this.sock.channel;
        boolean blockingMode = this.sock.isBlockingMode();
        ByteBuffer buf = null;
        if (this.buffers.size() > 0) {
            buf = (ByteBuffer)this.buffers.getLast();
        }
        while (this.size < this.maxSize) {
            int r;
            if (buf == null || buf.remaining() == 0) {
                buf = this.allocateBuffer();
                this.buffers.addLast(buf);
            }
            if ((r = channel.read(buf)) == 0) {
                NIOSelector.selectRead(this.sock.getSelectionKey(), true, needWakeup);
                break;
            }
            if (r < 0) {
                this.eof = true;
                break;
            }
            this.size += r;
            if (!blockingMode) continue;
            break;
        }
        return this.size;
    }
}

