/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.nio;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.nio.NIOSelector;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;

class NIOSocketOutput
extends OutputStream {
    final NIOSocket sock;
    final int maxSize;
    private int size = 0;
    final LinkedList buffers = new LinkedList();
    ByteBuffer currentBuffer;
    private boolean closed = false;
    private Throwable flushErr = null;

    NIOSocketOutput(NIOSocket sock) throws IOException {
        this.sock = sock;
        this.maxSize = sock.socket().getSendBufferSize();
        this.allocateBuffer();
    }

    private void allocateBuffer() {
        this.currentBuffer = NIOSelector.allocateBuffer();
    }

    private void validate() throws IOException {
        if (this.closed) {
            if (this.flushErr != null) {
                throw new RPCIOException(2003, "Stream closed.(" + this.flushErr.toString() + ")");
            }
            throw new RPCIOException(2003, "Stream closed.");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        while (this.size > 0) {
            this.flushData(true);
        }
        this.sock.socket().shutdownOutput();
        this.closed = true;
        this.notify();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.remaining();
        this.currentBuffer.put((byte)b);
        ++this.size;
    }

    private int remaining() throws IOException {
        while (this.size >= this.maxSize) {
            this.flushData(true);
        }
        if (this.currentBuffer.remaining() == 0) {
            this.currentBuffer.flip();
            this.buffers.addLast(this.currentBuffer);
            this.allocateBuffer();
        }
        return this.currentBuffer.remaining();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int l = this.remaining();
            if (l > len) {
                l = len;
            }
            this.currentBuffer.put(b, off, l);
            off += l;
            len -= l;
            this.size += l;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushData(false);
    }

    private void flushData(boolean wait) throws IOException {
        int lastSize = this.size;
        if (lastSize == 0) {
            return;
        }
        while (true) {
            this.validate();
            this.writeChannel(true);
            if (!wait || lastSize != this.size) break;
            try {
                long timeout = ServerManager.getConfig().nioWaitTimeout;
                if (timeout >= 0L) {
                    this.wait(timeout);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException e) {
                RPCException.createIt(e);
            }
        }
    }

    synchronized void notifyWritable() {
        NIOSelector.selectWrite(this.sock.getSelectionKey(), false, false);
        if (this.closed) {
            this.notify();
            return;
        }
        int lastSize = this.size;
        try {
            if (lastSize != this.writeChannel(false)) {
                this.notify();
            }
        }
        catch (Throwable e) {
            this.flushErr = e;
            IOUtil.close(this);
        }
    }

    private int writeChannel(boolean needWakeup) throws IOException {
        int r;
        ByteBuffer buffer;
        if (this.size == 0) {
            return 0;
        }
        SocketChannel channel = this.sock.channel;
        while (this.buffers.size() > 0) {
            buffer = (ByteBuffer)this.buffers.getFirst();
            while (buffer.remaining() > 0) {
                r = channel.write(buffer);
                if (r == 0) {
                    NIOSelector.selectWrite(this.sock.getSelectionKey(), true, needWakeup);
                    return this.size;
                }
                this.size -= r;
            }
            this.buffers.removeFirst();
        }
        if (this.size > 0) {
            buffer = this.currentBuffer;
            buffer.flip();
            this.allocateBuffer();
            while (buffer.remaining() > 0) {
                r = channel.write(buffer);
                if (r == 0) {
                    this.buffers.addLast(buffer);
                    NIOSelector.selectWrite(this.sock.getSelectionKey(), true, needWakeup);
                    return this.size;
                }
                this.size -= r;
            }
        }
        return 0;
    }
}

