/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.healthdegree.BaseHealthDegree;
import com.kingdee.bos.rpc.healthdegree.HealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.ServiceDispatcher;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalanceLocalizer;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NIOServer
extends Thread
implements IServer {
    static final Logger logger;
    public static final int DEFAULT_PORT = 11034;
    private int port;
    private ServerSocketChannel serverChannel;
    private final String redirectUrl;
    protected LoadBalanceLocalizer lbl;
    protected String serverName = "nio";
    private ServiceDispatcher dispatcher;
    private HashMap sessions;
    private IHealthDegree hd = new BaseHealthDegree();
    private boolean standby;
    private long interval = 10000L;

    public NIOServer(LoadBalanceLocalizer lbl, int port) throws IOException {
        this(port);
        this.lbl = lbl;
    }

    public NIOServer(ServerSocketChannel serverChannel, String redirectUrl) {
        super("RPC-Nio-Server(" + serverChannel.socket().getLocalPort() + ")");
        this.setDaemon(true);
        this.serverChannel = serverChannel;
        this.redirectUrl = redirectUrl;
        IHealthDegree ihd = ServerManager.getConfig((String)this.serverName).healthDegree;
        if (ihd != null) {
            this.hd = ihd;
            ((HealthDegree)this.hd).startSample();
        }
        ServerManager.registerServer(this);
    }

    private static ServerSocketChannel open(SocketAddress addr, String serverName) throws IOException {
        ServerSocketChannel sc2 = ServerSocketChannel.open();
        Boolean b = ServerManager.getConfig((String)serverName).reuseAddress;
        if (b != null) {
            sc2.socket().setReuseAddress(b);
        }
        sc2.socket().bind(addr);
        return sc2;
    }

    private static ServerSocketChannel open(int port, String serverName) throws IOException {
        return NIOServer.open(new InetSocketAddress(port), serverName);
    }

    public NIOServer(SocketAddress addr, String redirectUrl) throws IOException {
        this(NIOServer.open(addr, "nio"), redirectUrl);
    }

    public NIOServer(String serverName, int port, String redirectUrl) throws IOException {
        super("RPC-Nio-Server(" + port + ")");
        this.setDaemon(true);
        this.port = port;
        this.redirectUrl = redirectUrl;
        this.serverName = serverName;
        IHealthDegree ihd = ServerManager.getConfig((String)serverName).healthDegree;
        if (ihd != null) {
            this.hd = ihd;
            ((HealthDegree)this.hd).startSample();
        }
        this.standby = ServerManager.getConfig((String)serverName).standby;
        if (!this.standby) {
            try {
                this.serverChannel = NIOServer.open(port, serverName);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                logger.error((Object)e, (Throwable)e);
            }
        }
        ServerManager.registerServer(this);
    }

    public NIOServer(SocketAddress addr) throws IOException {
        this(addr, null);
    }

    public NIOServer(int port) throws IOException {
        this("nio", port, null);
    }

    public NIOServer(String redirectUrl) throws IOException {
        this("nio", 11034, redirectUrl);
    }

    public NIOServer() throws IOException {
        this(11034);
    }

    @Override
    public void shutdown() {
        IOUtil.close(this.serverChannel);
    }

    @Override
    public void run() {
        if (this.standby) {
            logger.info((Object)(this.getName() + " standby."));
            while (true) {
                try {
                    Socket sock = new Socket(InetAddress.getByName(null), this.port);
                    IOUtil.close(sock);
                }
                catch (UnknownHostException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (IOException e1) {
                    try {
                        this.serverChannel = NIOServer.open(this.port, this.serverName);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e, (Throwable)e);
                    break;
                }
            }
        }
        logger.info((Object)(this.getName() + " start."));
        try {
            while (true) {
                SocketChannel channel = this.serverChannel.accept();
                RPCEngine.startThread(new Connection(channel, this));
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Override
    public RPCConfig getConfig() {
        ServerManager.setCurrentServer(this.serverName);
        RPCConfig config = ServerManager.getConfig();
        ServerManager.setCurrentServer(null);
        return config;
    }

    @Override
    public Map statistics() {
        return null;
    }

    @Override
    public boolean hasStandby() {
        return false;
    }

    @Override
    public ServiceDispatcher getServiceDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new ServiceDispatcher(this.serverName);
        }
        return this.dispatcher;
    }

    @Override
    public Map getSessions() {
        if (this.sessions == null) {
            this.sessions = PerformanceManager.createHashMap(this.serverName + "." + "ServerSession.count");
        }
        return this.sessions;
    }

    @Override
    public Map getHealthDegree() {
        return null;
    }

    public IHealthDegree getIHealthDegree() {
        return this.hd;
    }

    public void removeHealthDegree() {
        this.hd = null;
    }

    @Override
    public boolean match(String url) {
        String ip = this.serverChannel.socket().getInetAddress().getHostAddress();
        int port = this.serverChannel.socket().getLocalPort();
        String ip2 = url.substring(url.indexOf("//"), url.lastIndexOf(":"));
        String temp = url.substring(url.lastIndexOf(":"));
        int port2 = Integer.parseInt(temp);
        if ("0.0.0.0".equals(ip) || "localhost".equalsIgnoreCase(ip2) || "127.0.0.1".equals(ip2)) {
            return port == port2;
        }
        return port == port2 && ip.equals(ip2);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    static {
        RPCEngine.class.getClass();
        logger = Logger.getLogger(NIOServer.class);
    }

    private class Connection
    implements Runnable {
        SocketChannel channel;
        NIOServer server;

        Connection(SocketChannel channel, NIOServer server) {
            this.channel = channel;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerManager.setCurrentServer(NIOServer.this.serverName);
                RPCConnection conn = new RPCConnection(this.server);
                conn.clientIp = this.channel.socket().getInetAddress().toString();
                conn.serverIp = this.channel.socket().getLocalAddress().getHostAddress();
                if (NIOServer.this.lbl != null) {
                    conn.setLbl(NIOServer.this.lbl);
                }
                conn.nioAccept(NIOServer.this.getName(), this.channel, NIOServer.this.redirectUrl);
            }
            catch (Throwable e) {
                IOUtil.close(this.channel);
                IOUtil.logIOError(logger, e);
            }
            finally {
                ServerManager.setCurrentServer(null);
            }
        }
    }
}

