/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.netty.Response;
import com.kingdee.bos.rpc.netty.ResponseCallback;
import com.kingdee.bos.rpc.netty.ResponseFuture;
import com.kingdee.bos.rpc.netty.RpcNettyMsgHead;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class DefaultFuture
implements ResponseFuture {
    private static final Logger logger = Logger.getLogger(DefaultFuture.class);
    private static final Map<Long, DefaultFuture> FUTURES = new ConcurrentHashMap<Long, DefaultFuture>();
    private static final Map<ChannelId, Throwable> exceptions = new ConcurrentHashMap<ChannelId, Throwable>();
    private final long id;
    private final Channel channel;
    private final int timeout;
    private final Lock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();
    private final long start = System.currentTimeMillis();
    private volatile long sent;
    private volatile ResponseCallback callback;
    private Response response;
    private final RPCInvoke rpcInvoke;
    private boolean isNeedConverted;

    public DefaultFuture(Channel channel, RPCInvoke rpcInvoke, long id, int timeout) {
        this.channel = channel;
        this.rpcInvoke = rpcInvoke;
        this.id = id;
        this.timeout = timeout;
        FUTURES.put(id, this);
    }

    public boolean isNeedConverted() {
        return this.isNeedConverted;
    }

    public void setNeedConverted(boolean isNeedConverted) {
        this.isNeedConverted = isNeedConverted;
    }

    @Override
    public Object get() throws Exception {
        return this.get(this.timeout);
    }

    @Override
    public Object get(int timeout) throws Exception {
        if (timeout <= 0) {
            timeout = 3000;
        }
        if (!this.isDone()) {
            long start = System.currentTimeMillis();
            this.lock.lock();
            try {
                while (!this.isDone()) {
                    this.done.await(3000L, TimeUnit.MILLISECONDS);
                    if (this.isDone()) break;
                    if (System.currentTimeMillis() - start > (long)timeout) {
                        break;
                    }
                    Throwable t = this.getException(this.channel);
                    if (t == null) continue;
                    throw RPCException.createIt(t);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
            if (!this.isDone()) {
                throw new TimeoutException(this.getTimeoutMessage(false));
            }
        }
        return this.returnFromResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallback(ResponseCallback callback) {
        if (this.isDone()) {
            this.invokeCallback(callback);
        } else {
            boolean isdone = false;
            this.lock.lock();
            try {
                if (!this.isDone()) {
                    this.callback = callback;
                } else {
                    isdone = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (isdone) {
                this.invokeCallback(callback);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    public Throwable getException(Channel ch2) {
        Throwable t = exceptions.get(ch2.id());
        if (t == null && !this.channel.isActive()) {
            t = new SocketException("channel is closed and channel is " + this.channel);
        }
        return t;
    }

    public static void sent(Channel channel, long randomId) {
        DefaultFuture future = FUTURES.get(randomId);
        if (future != null) {
            future.doSent();
        }
    }

    public static void received(Channel channel, ByteBuf byteBuf) {
        Long randomId = 0L;
        try {
            RpcNettyMsgHead msgHead = RpcNettyMsgHead.readFromByteBuf(byteBuf);
            randomId = msgHead.getMsgId();
        }
        catch (Exception e) {
            logger.warn((Object)("The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", randomId error" + (channel == null ? "" : ", channel: " + channel.localAddress() + " -> " + channel.remoteAddress())));
        }
        DefaultFuture future = FUTURES.remove(randomId);
        if (logger.isDebugEnabled()) {
            long cost = System.currentTimeMillis() - future.getStartTimestamp();
            logger.debug((Object)("rpcinvoke channelRead. randomId is " + randomId + " cost : " + cost));
        }
        if (future != null) {
            future.doReceived(byteBuf);
        } else {
            logger.warn((Object)("The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", randomId " + randomId + (channel == null ? "" : ", channel: " + channel.localAddress() + " -> " + channel.remoteAddress())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReceived(ByteBuf res) {
        this.lock.lock();
        try {
            this.response = new Response(res, this.rpcInvoke, this.isNeedConverted);
            if (this.done != null) {
                this.done.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.invokeCallback(this.callback);
        }
    }

    private void invokeCallback(ResponseCallback c) {
        ResponseCallback callbackCopy = c;
        if (callbackCopy == null) {
            throw new NullPointerException("callback cannot be null.");
        }
        c = null;
        Response res = this.response;
        if (res == null) {
            throw new IllegalStateException("response cannot be null. url:" + this.channel.remoteAddress());
        }
        if (res.getStatus() == 20) {
            try {
                callbackCopy.done(res.getResult());
            }
            catch (Exception e) {
                logger.error((Object)("callback invoke error .reasult:" + res.getResult() + ",url:" + this.channel.remoteAddress()), (Throwable)e);
            }
        } else {
            try {
                callbackCopy.caught(res.getErrorMsg());
            }
            catch (Exception e) {
                logger.error((Object)("callback invoke error ,url:" + this.channel.remoteAddress()), (Throwable)e);
            }
        }
    }

    private Object returnFromResponse() {
        Response res = this.response;
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (this.isNeedConverted()) {
            if (res.getStatus() == 20) {
                return res.getResult();
            }
            throw RPCException.createIt(res.getErrorMsg());
        }
        ByteBuf byteBuf = res.getResp();
        return new ByteBufInputStream(byteBuf, true);
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side") + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSent() {
        return this.sent > 0L;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getStartTimestamp() {
        return this.start;
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    public static void handleException(Channel ch2, Throwable t) {
        exceptions.put(ch2.id(), t);
    }
}

