/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.ClientIpUtil;
import com.kingdee.bos.rpc.io.driver.PooledSocket;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.driver.SocketPool;
import com.kingdee.bos.rpc.netty.NettyClient;
import com.kingdee.bos.rpc.netty.handler.NettyChannelPoolHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class NettyChannelPool {
    static final Logger logger = Logger.getLogger(NettyChannelPool.class);
    private static EventLoopGroup group = new NioEventLoopGroup();
    private static Bootstrap bootstrap = new Bootstrap();
    private static ChannelPoolMap<InetSocketAddress, SimpleChannelPool> poolMap;
    private SimpleChannelPool currentPool;
    public static final NettyChannelPool INS;
    private static volatile Map<ChannelId, String> channelMap;

    private NettyChannelPool() {
        try {
            this.build();
            NettyHook hook = new NettyHook();
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (Exception e) {
            logger.error((Object)"NettyChannelPool init fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void build() {
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        poolMap = new AbstractChannelPoolMap<InetSocketAddress, SimpleChannelPool>(){

            protected SimpleChannelPool newPool(InetSocketAddress key) {
                return new FixedChannelPool(bootstrap.remoteAddress((SocketAddress)key), (ChannelPoolHandler)new NettyChannelPoolHandler(), ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 0L, 50, Integer.MAX_VALUE);
            }
        };
    }

    public void release(Channel ch2) {
        if (ch2 != null) {
            this.currentPool.release(ch2);
        }
    }

    Channel getChannel(InetSocketAddress address, Properties props) {
        this.currentPool = (SimpleChannelPool)poolMap.get((Object)address);
        Future f = this.currentPool.acquire();
        Channel channel = null;
        try {
            channel = (Channel)f.get();
            this.connect(channel, address.toString(), props);
        }
        catch (Exception e) {
            throw new RPCException("address is " + address, (Throwable)e);
        }
        return channel;
    }

    public Channel getChannel(String url, Properties props) throws Exception {
        String newurl = RPCConnection.parseQuery(url, props);
        InetSocketAddress address = RPCConnection.getAddress(newurl, 11034);
        return this.getChannel(address, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String rpcConnect(Channel channel, String url, Properties props) throws Exception, IOException {
        String lbUrl = null;
        if (channelMap.containsKey(channel.id())) {
            return channelMap.get(channel.id());
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channelMap.containsKey(channel.id())) {
                return channelMap.get(channel.id());
            }
            boolean getClientIp = ClientIpUtil.shouldGet();
            if (getClientIp) {
                props.put("getClientIp", "true");
            }
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.buffer();
            ByteBufOutputStream out = new ByteBufOutputStream(byteBuf);
            IOUtil.writeLine((OutputStream)out, "RPC_INVOKE " + url + " " + "RPC_POOL/1.0");
            IOUtil.writeProperties((OutputStream)out, props);
            ByteBufInputStream in = NettyClient.invoke(channel, out.buffer());
            try {
                String line = IOUtil.readLine((InputStream)in);
                try {
                    int code;
                    int index = line.indexOf(32);
                    int index1 = line.indexOf(32, index + 1);
                    String ver = line.substring(0, index);
                    if (!ver.equals("RPC_POOL/1.0")) {
                        NettyChannelPool.notRPCServer(line);
                    }
                    if ((code = Integer.parseInt(line.substring(index + 1, index1).trim())) != 200) {
                        if (code == 500) {
                            throw new RPCConnectException(code, line + "  url: " + url, 6001);
                        }
                        if (code == 1005) {
                            throw new RPCConnectException(code, line);
                        }
                        throw new RPCIOException(code, line);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof RPCConnectException) {
                        throw (RPCConnectException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    IOUtil.logIOError(logger, e);
                    NettyChannelPool.notRPCServer(line);
                }
                IOUtil.readProperties((InputStream)in, props);
                if (RPCService.inServiceInvoke.get() != null && RPCEngine.identity.equals(props.get("engineId")) && RPCService.inServiceInvoke.get().equals(props.get("serverName"))) {
                    throw new RuntimeException("Not support remote call to self in remote proxy!");
                }
                lbUrl = props.getProperty("lbUrl");
                props.remove("lbUrl");
                if (getClientIp) {
                    props.remove("getClientIp");
                    String clientInetAddress = props.getProperty("clientInetAddress");
                    ClientIpUtil.setAddress(clientInetAddress);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            channelMap.put(channel.id(), lbUrl);
        }
        return lbUrl;
    }

    private static void notRPCServer(String response) throws IOException {
        String msg = "Server is not a RPC server.";
        if (response != null) {
            msg = msg + " the response is '" + response + "'";
        }
        throw new RPCIOException(2006, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Channel channel, String url, Properties props) throws Exception {
        SocketPool pool;
        SocketPool socketPool = pool = SocketPool.getPool(url);
        synchronized (socketPool) {
            PooledSocket sock = pool.get();
            if (sock == null) {
                sock = new _Socket(SocketPool.getPool(url), null, null, null, url, props);
            }
            pool.checkConnectTimeoutRecently();
            try {
                if (pool.getEngineId() == null) {
                    props.remove("engineId");
                } else {
                    props.setProperty("engineId", pool.getEngineId());
                }
                IOUtil.appendProperties(props, sock.props);
                this.connect0(channel, url, props);
                pool.setEngineId(props.getProperty("engineId"));
                String isByLB = props.getProperty("isByLB");
                if ("true".equalsIgnoreCase(isByLB)) {
                    SocketPool.setByLB(true);
                } else {
                    SocketPool.setByLB(false);
                }
                pool.add(sock);
            }
            catch (Exception e) {
                if (RPCException.getErrorCode(e) == 1005 || e instanceof RPCConnectException) {
                    props.remove("engineId");
                    pool.setEngineId(null);
                    try {
                        this.connect0(channel, url, props);
                    }
                    catch (IOException ioe) {
                        pool.setConnectTimeout();
                        logger.error((Object)("Socket connect timeout:" + url), (Throwable)e);
                        throw ioe;
                    }
                    pool.setEngineId(props.getProperty("engineId"));
                    String isByLB = props.getProperty("isByLB");
                    if ("true".equalsIgnoreCase(isByLB)) {
                        SocketPool.setByLB(true);
                    } else {
                        SocketPool.setByLB(false);
                    }
                }
                pool.setConnectTimeout();
                logger.error((Object)("Socket connect timeout:" + url), (Throwable)e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
        }
    }

    private void connect0(Channel channel, String url, Properties props) throws Exception, IOException {
        String lbUrl = this.rpcConnect(channel, url, props);
        if (lbUrl != null && RPCConnection.lbUrlTL.get() == null) {
            props.remove("engineId");
            props.remove("serverName");
            RPCConnection.lbUrlTL.set(lbUrl);
        }
    }

    static {
        INS = new NettyChannelPool();
        channelMap = new WeakHashMap<ChannelId, String>();
    }

    private class NettyHook
    extends Thread {
        private NettyHook() {
        }

        @Override
        public void run() {
            try {
                group.shutdownGracefully();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    class _Socket
    extends PooledSocket {
        _Socket(SocketPool pool, Socket sock, DataInputStream in, DataOutputStream out, String url, Properties props) {
            super(pool, sock, in, out, url, props);
        }

        @Override
        protected boolean releaseSocket() {
            return true;
        }

        protected short getCurrentIndex() {
            return this.currentIndex;
        }

        @Override
        public synchronized void closeInput(short index) throws IOException {
            super.closeInput(index);
        }

        @Override
        public synchronized void closeOutput(short index) throws IOException {
            super.closeOutput(index);
        }

        @Override
        public long getIdleTime() {
            return 0L;
        }
    }
}

