/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.netty.NettyChannelPool;
import com.kingdee.bos.rpc.netty.NettyClient;
import com.kingdee.bos.rpc.netty.NettyPooledTCPConnection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NettyInvokeHelper
implements InvokeHelper {
    private final NettyPooledTCPConnection cn;
    private InputStream in;
    private OutputStream out;
    private boolean isInvoke;

    public NettyInvokeHelper(NettyPooledTCPConnection cn, InputStream in, OutputStream out, boolean isInvoke) {
        this.cn = cn;
        this.isInvoke = isInvoke;
        this.reset(in, out);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public Connection getConnection() {
        return this.cn;
    }

    @Override
    public void close() {
    }

    @Override
    public void setSocketOption() {
    }

    public void invoke() {
        if (!this.isInvoke) {
            return;
        }
        Channel channel = null;
        try {
            channel = NettyChannelPool.INS.getChannel(this.cn.getConnectionUrl(), this.cn.getConnectionProps());
            if (!(this.out instanceof ByteBufOutputStream)) {
                throw new RPCException(3001, "OutputStream must be ByteBufOutputStream");
            }
            this.in = NettyClient.invoke(channel, ((ByteBufOutputStream)this.out).buffer());
            this.reset(this.in, this.out);
            if (channel != null) {
                NettyChannelPool.INS.release(channel);
            }
        }
        catch (Exception e) {
            try {
                throw RPCException.createIt(e);
            }
            catch (Throwable throwable) {
                if (channel != null) {
                    NettyChannelPool.INS.release(channel);
                }
                throw throwable;
            }
        }
    }

    private void reset(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out instanceof ByteBufOutputStream ? new _Output(((ByteBufOutputStream)out).buffer()) : out;
    }

    class _Output
    extends ByteBufOutputStream {
        private volatile boolean isClosed;

        public _Output(ByteBuf buffer) {
            super(buffer);
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            super.close();
            NettyInvokeHelper.this.invoke();
            this.isClosed = true;
        }
    }
}

