/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.netty.NettyChannelPool;
import com.kingdee.bos.rpc.netty.NettyInvokeHelper;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class NettyPooledTCPConnection
extends ConnectionBase {
    static final Logger logger = Logger.getLogger(NettyPooledTCPConnection.class);
    public final boolean beClient;
    private IntValue objectCounterClientConnectionCount;

    public NettyPooledTCPConnection(String url, Properties props, boolean beClient) {
        super(url, props);
        this.beClient = beClient;
        if (beClient) {
            try {
                this.connect(url, props);
            }
            catch (Exception e) {
                throw new RPCException(e);
            }
        } else {
            this.objectCounterClientConnectionCount = PerformanceManager.getIntValue("ClientConnectionCount");
            this.objectCounterClientConnectionCount.append(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String url, Properties props) throws Exception {
        Channel channel = null;
        try {
            channel = NettyChannelPool.INS.getChannel(url, props);
        }
        finally {
            if (channel != null) {
                NettyChannelPool.INS.release(channel);
            }
        }
    }

    @Override
    public InvokeHelper newInvokeHelper() throws IOException {
        ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.buffer();
        ByteBufInputStream in = new ByteBufInputStream(byteBuf, true);
        ByteBufOutputStream out = new ByteBufOutputStream(byteBuf);
        return new NettyInvokeHelper(this, (InputStream)in, (OutputStream)out, true);
    }

    public InvokeHelper newInvokeHelper(InputStream in, OutputStream out, boolean isInvoke) throws IOException {
        return new NettyInvokeHelper(this, in, out, isInvoke);
    }

    @Override
    protected void finalClose() throws Throwable {
    }

    public NettyPooledTCPConnection _getConnection() {
        return this;
    }

    public ConnectionHelper getRedirect() {
        return this.redirect;
    }
}

