/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty.handler;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.NettyServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.RpcNettyMsgHead;
import com.kingdee.bos.rpc.netty.handler.AbstractRpcServiceHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RpcInstanceServiceHandler
extends AbstractRpcServiceHandler {
    public RpcInstanceServiceHandler(NettyServer server) {
        super(server);
    }

    @Override
    public void handlerMsg(final ChannelHandlerContext ctx, final ByteBuf byteBuf) throws Exception {
        ConnectionHelper redirect = this.cn.getRedirect();
        if (redirect != null) {
            throw new IllegalStateException("RpcInstanceServiceHandler only handle requests that point to instance");
        }
        RPCEngine.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ServerManager.setCurrentServer(RpcInstanceServiceHandler.this.server.getName());
                    RpcInstanceServiceHandler.this.service(ctx, byteBuf);
                }
                catch (Exception e) {
                    AbstractRpcServiceHandler.logger.error((Object)"rpc error", (Throwable)e);
                    ctx.channel().write((Object)e);
                }
                finally {
                    ServerManager.setCurrentServer(null);
                }
            }
        });
    }

    private void service(ChannelHandlerContext ctx, ByteBuf byteBuf) throws IOException {
        Channel channel = ctx.channel();
        RpcNettyMsgHead msgHead = RpcNettyMsgHead.readFromByteBuf(byteBuf);
        long msgId = msgHead.getMsgId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rpcservice channelRead receive. randomId is " + msgId));
        }
        if (0 == msgHead.getCommand()) {
            ReferenceCountUtil.release((Object)byteBuf);
            return;
        }
        ByteBuf byteBufOut = msgHead.writeToByteBuf();
        ByteBufInputStream in = new ByteBufInputStream(byteBuf, true);
        ByteBufOutputStream out = new ByteBufOutputStream(byteBufOut);
        InvokeHelper helper = this.cn.newInvokeHelper((InputStream)in, (OutputStream)out, false);
        ConnectionHelper redirect = this.cn.getRedirect();
        if (redirect == null) {
            RPCService.service(IOManager.createInvokeHelper(null, helper, false));
        }
        channel.write((Object)out.buffer());
        channel.writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rpcservice channelRead write back success. randomId is " + msgId));
        }
    }
}

