/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty.handler;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.netty.DefaultFuture;
import com.kingdee.bos.rpc.netty.FutureAdapter;
import com.kingdee.bos.rpc.netty.NettyChannelRefCnt;
import com.kingdee.bos.rpc.netty.NettyUtil;
import com.kingdee.bos.rpc.netty.RpcContext;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.RpcNettyMsgHead;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.log4j.Logger;

public class RpcInvokeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(RpcInvokeHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)cause);
        DefaultFuture.handleException(ctx.channel(), cause);
        super.exceptionCaught(ctx, cause);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NettyChannelRefCnt.decrement(ctx.channel());
        ByteBuf byteBuf = (ByteBuf)msg;
        DefaultFuture.received(ctx.channel(), byteBuf);
    }

    public ByteBufInputStream sendMessage(Channel ch2, ByteBuf message) throws Exception {
        boolean async;
        RpcContext rpcCtx = RpcContext.getContext();
        Long randomId = NettyUtil.getRandomKey();
        DefaultFuture future = new DefaultFuture(ch2, rpcCtx.getRpcInvoke(), randomId, 1800000);
        future.setCallback(rpcCtx.getCallback());
        future.setNeedConverted(rpcCtx.isAsync());
        RpcNettyMsgHead msgHead = new RpcNettyMsgHead(randomId, 1);
        ByteBuf head = msgHead.writeToByteBuf();
        ch2.write((Object)head);
        ch2.write((Object)message);
        ChannelFuture cf = ch2.writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
        NettyChannelRefCnt.increment(ch2);
        DefaultFuture.sent(ch2, randomId);
        Throwable cause = cf.cause();
        if (cause != null) {
            throw RPCException.createIt(cause);
        }
        if (logger.isDebugEnabled()) {
            ChannelId channelId = ch2.id();
            logger.debug((Object)("rpcinvoke sendMessage. randomId is " + randomId + " channelId is " + channelId + " channel " + ch2.remoteAddress()));
        }
        if (async = rpcCtx.isAsync()) {
            RpcContext.getContext().setFuture(new FutureAdapter(future));
            return null;
        }
        RpcContext.getContext().setFuture(null);
        return (ByteBufInputStream)future.get();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"rpc invoke register");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        NettyChannelRefCnt.release(ctx.channel());
    }
}

