/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.performance;

import com.kingdee.bos.rpc.performance.PerformanceValue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IntValue
extends PerformanceValue {
    private int value;
    private int max;
    private int min;
    IntValue parent = null;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    IntValue(String name, int initValue) {
        super(name);
        this.value = initValue;
        this.max = initValue;
        this.min = initValue;
    }

    @Override
    public Class type() {
        return Integer.class;
    }

    @Override
    public Object value() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParent(IntValue parent) {
        try {
            this.rwl.writeLock().lock();
            this.parent = parent;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        try {
            this.rwl.writeLock().lock();
            int diff = value - this.value;
            if (diff == 0) {
                return;
            }
            if (this.parent != null) {
                this.parent.append(diff);
            }
            this.value = value;
            if (this.min > value) {
                this.min = value;
            }
            if (this.max < value) {
                this.max = value;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(int append) {
        try {
            this.rwl.writeLock().lock();
            this.setValue(this.value + append);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue() {
        try {
            this.rwl.readLock().lock();
            int n = this.value;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxValue() {
        try {
            this.rwl.readLock().lock();
            int n = this.max;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinValue() {
        try {
            this.rwl.readLock().lock();
            int n = this.min;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        try {
            this.rwl.readLock().lock();
            String string = this.name + "\t:value=" + this.value + " min=" + this.min + " max=" + this.max;
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

