/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.performance;

import com.kingdee.bos.rpc.performance.CounterValue;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.LongValue;
import com.kingdee.bos.rpc.performance.MaxIntValue;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class PerformanceManager {
    public static final String THREADPOOL_FREECOUNT = "ThreadPool.freeCount";
    public static final String THREADPOOL_ACTIVECOUNT = "ThreadPool.activeCount";
    public static final String SERVICE_THREADCOUNT = "Service.threadCount";
    public static final String SERVICE_PROCESSINGCOUNT = "Service.processingCount";
    public static final String SERVICE_PROCESSEDCOUNT = "Service.processedCount";
    public static final String SERVICE_WAITINGCOUNT = "Service.waitingCount";
    public static final String SERVERSESSION_COUNT = "ServerSession.count";
    public static final String SERVERSESSION_PROXYCOUNT = "ServerSession.proxyCount";
    public static final String CLIENTSESSION_COUNT = "ClientSession.count";
    public static final String CLIENTSESSION_STUBCOUNT = "ClientSession.stubCount";
    public static final String CONNECTION_CLIENT_COUNT = "Connection.client.count";
    public static final String CONNECTION_SERVER_COUNT = "Connection.server.count";
    public static final String CONNECTION_HTTP_COUNT = "Connection.http.count";
    public static final String CLIENT_INVOKE_COUNT = "Client.invokeCount";
    public static final String COUNTER_POST_FIX = ".perMinute";
    public static final String RPC_INVOKE_ACCUMULATED_TIME = "RPC.Invoke.AccumulatedTime";
    public static final String RPC_INVOKE_ACCUMULATED_COUNT = "RPC.Invoke.AccumulatedCount";
    public static final String RPC_INVOKE_ACCUMULATED_BYTE = "RPC.Invoke.AccumulatedByte";
    public static final String RPC_INVOKE_MAX_TIME = "RPC.Invoke.MaxTime";
    public static final String ClientSessionCount = "ClientSessionCount";
    public static final String ClientConnectionCount = "ClientConnectionCount";
    private static final HashMap<String, PerformanceValue> values = new HashMap();
    public static final String SYSTEM_THREAD_COUNT = "system.activeThreadCount";
    public static final String SYSTEM_TOTAL_MEMORY = "system.memory.total";
    public static final String SYSTEM_FREE_MEMORY = "system.memory.free";
    public static final String SYSTEM_USED_MEMORY = "system.memory.used";
    public static final String SYSTEM_TIME = "system.time";
    private static final DateFormat df;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            values.clear();
        }
    }

    public static IntValue getIntValue(String parentName, String name) {
        IntValue parent = PerformanceManager.getIntValue(parentName);
        IntValue value = PerformanceManager.getIntValue(name);
        value.setParent(parent);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(PerformanceValue value) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            values.put(value.name(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeValue(PerformanceValue value) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            values.remove(value.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceValue getValue(String name) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            return values.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceValue[] getValues(String[] names) {
        if (names == null) {
            return null;
        }
        PerformanceValue[] vs = new PerformanceValue[names.length];
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            for (int i = 0; i < vs.length; ++i) {
                vs[i] = values.get(names[i]);
            }
        }
        return vs;
    }

    public static IntValue getIntValue(String name) {
        return PerformanceManager.getIntValue(name, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntValue getIntValue(String name, int initValue) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            IntValue v = (IntValue)values.get(name);
            if (v == null) {
                v = new IntValue(name, initValue);
                values.put(name, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CounterValue getCounterValue(String name) {
        String counterName = name + COUNTER_POST_FIX;
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            CounterValue v = (CounterValue)values.get(counterName);
            if (v == null) {
                v = new CounterValue(counterName, PerformanceManager.getLongValue(name));
                values.put(counterName, v);
            }
            return v;
        }
    }

    public static MaxIntValue getMaxIntValue(String name) {
        return PerformanceManager.getMaxIntValue(name, 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MaxIntValue getMaxIntValue(String name, int interval) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            MaxIntValue v = (MaxIntValue)values.get(name);
            if (v == null) {
                v = new MaxIntValue(name, interval);
                values.put(name, v);
            }
            return v;
        }
    }

    public static LongValue getLongValue(String name) {
        return PerformanceManager.getLongValue(name, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongValue getLongValue(String name, long initValue) {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            LongValue v = (LongValue)values.get(name);
            if (v == null) {
                v = new LongValue(name, initValue);
                values.put(name, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceValue[] getValues() {
        HashMap<String, PerformanceValue> hashMap = values;
        synchronized (hashMap) {
            return values.values().toArray(new PerformanceValue[values.size()]);
        }
    }

    public static void dump(PrintStream out) {
        PerformanceValue[] vs = PerformanceManager.getValues();
        for (int i = 0; i < vs.length; ++i) {
            out.println(vs[i].toString());
        }
    }

    public static void dump() {
        Object[] vs = PerformanceManager.getValues();
        Arrays.sort(vs);
        for (int i = 0; i < vs.length; ++i) {
            System.out.println(((PerformanceValue)vs[i]).toString());
        }
    }

    public static LinkedList createLinkedList(String name) {
        return new _LinkedList(PerformanceManager.getIntValue(name));
    }

    public static HashMap createHashMap(String name) {
        return new _HashMap(PerformanceManager.getIntValue(name));
    }

    private static void append(StringBuffer sb, int value) {
        int h = value / 10;
        int l = value % 10;
        sb.append(h);
        sb.append(l);
    }

    public static String formatTime(long time) {
        return df.format(new Date(time));
    }

    public static String timeToString(long time) {
        long s = (time /= 1000L) % 60L;
        long m = time / 60L % 60L;
        long h = time / 3600L % 24L;
        long d = time / 3500L / 24L;
        StringBuffer sb = new StringBuffer();
        if (d > 0L) {
            sb.append(d).append(" day(s) ");
        }
        PerformanceManager.append(sb, (int)h);
        sb.append(":");
        PerformanceManager.append(sb, (int)m);
        sb.append(":");
        PerformanceManager.append(sb, (int)s);
        return sb.toString();
    }

    static {
        PerformanceManager.setValue(new PerformanceValue(SYSTEM_THREAD_COUNT){

            @Override
            public Object value() {
                return Thread.activeCount();
            }
        });
        PerformanceManager.setValue(new PerformanceValue(SYSTEM_TOTAL_MEMORY){

            @Override
            public Object value() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        PerformanceManager.setValue(new PerformanceValue(SYSTEM_FREE_MEMORY){

            @Override
            public Object value() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        PerformanceManager.setValue(new PerformanceValue(SYSTEM_USED_MEMORY){

            @Override
            public Object value() {
                return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
        });
        PerformanceManager.setValue(new PerformanceValue(SYSTEM_TIME){
            final long t0 = System.currentTimeMillis();

            @Override
            public Object value() {
                long time = System.currentTimeMillis() - this.t0;
                return PerformanceManager.timeToString(time);
            }
        });
        df = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss.SSS");
    }

    private static class _HashMap
    extends HashMap {
        IntValue counter;

        _HashMap(IntValue counter) {
            this.counter = counter;
        }

        @Override
        public synchronized void clear() {
            this.counter.append(-this.size());
            super.clear();
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            int size = this.size();
            Object r = super.put(key, value);
            this.counter.append(this.size() - size);
            return r;
        }

        @Override
        public synchronized Object remove(Object key) {
            int size = this.size();
            Object r = super.remove(key);
            this.counter.append(this.size() - size);
            return r;
        }
    }

    private static class _LinkedList
    extends LinkedList {
        final IntValue counter;

        _LinkedList(IntValue counter) {
            this.counter = counter;
        }

        @Override
        public synchronized void addFirst(Object o) {
            super.addFirst(o);
            this.counter.append(1);
        }

        @Override
        public synchronized void addLast(Object o) {
            super.addLast(o);
            this.counter.append(1);
        }

        @Override
        public synchronized Object removeFirst() {
            this.counter.append(-1);
            return super.removeFirst();
        }

        @Override
        public synchronized Object removeLast() {
            this.counter.append(-1);
            return super.removeLast();
        }
    }
}

