/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.recordSlowReq;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.asistant.GetSqlPlanFileFactory;
import com.kingdee.bos.rpc.recordSlowReq.Constant;
import com.kingdee.bos.rpc.recordSlowReq.HttpUtil;
import com.kingdee.bos.rpc.recordSlowReq.request.WriteFileInfoReq;
import com.kingdee.bos.rpc.recordSlowReq.response.FuncListResp;
import com.kingdee.bos.rpc.recordSlowReq.response.GetFileUploadUrlResp;
import com.kingdee.bos.rpc.recordSlowReq.response.GetLockResp;
import com.kingdee.bos.rpc.recordSlowReq.response.GetTokenResp;
import com.kingdee.bos.rpc.recordSlowReq.response.WriteFileInfoResp;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CallCloudSide {
    private static String cloudSideAddress = null;
    private static final String getSwitchPath = "getswitch";
    private static final String writeFileInfoPath = "uploaded";
    private static final String getLockPath = "getlock";
    private static final String getTokenPath = "accesstoken";
    private static final String getUpLoadUrlPath = "uploadurl";
    private static final Logger logger = Logger.getLogger(CallCloudSide.class);

    public static void setAddress(String url) {
        cloudSideAddress = url;
    }

    public static String getAddress() {
        return cloudSideAddress;
    }

    public static GetFileUploadUrlResp getUrl(Map map) {
        String url = cloudSideAddress + getUpLoadUrlPath;
        logger.info((Object)"\u5f00\u59cb\u8c03\u7528\u4e91\u7aef\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6url");
        String result = HttpUtil.get(url, map, 5000, 5000, "UTF-8");
        logger.info((Object)("\u8c03\u7528\u4e91\u7aef\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6url\uff0c\u4e91\u7aef\u8fd4\u56de:" + result));
        if (result == null) {
            return null;
        }
        GetFileUploadUrlResp getFileUploadUrlResp = null;
        try {
            getFileUploadUrlResp = (GetFileUploadUrlResp)JSON.parseObject((String)result, GetFileUploadUrlResp.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return getFileUploadUrlResp;
    }

    public static GetTokenResp getToken(String sn) {
        String url = cloudSideAddress + getTokenPath;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        logger.info((Object)("\u8c03\u7528\u4e91\u7aef\u83b7\u53d6accessToken\uff0c\u4e91\u7aef\u8fd4\u56de:" + result));
        if (result == null) {
            return null;
        }
        GetTokenResp getTokenResp = null;
        try {
            getTokenResp = (GetTokenResp)JSON.parseObject((String)result, GetTokenResp.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return getTokenResp;
    }

    public static WriteFileInfoResp uploadFileInfo(WriteFileInfoReq writeFileInfoReq) {
        String url = cloudSideAddress + writeFileInfoPath;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", writeFileInfoReq.getAction());
        params.put("fileId", writeFileInfoReq.getFileId());
        params.put("logId", writeFileInfoReq.getLogId().replace("-", ""));
        params.put("logName", writeFileInfoReq.getLogName());
        params.put("sn", writeFileInfoReq.getSn());
        String result = HttpUtil.jsonRequest(url, JSON.toJSONString(params));
        logger.info((Object)("\u8c03\u7528\u4e91\u7aef\u56de\u5199\u6587\u4ef6\u4fe1\u606f\uff0c\u4e91\u7aef\u8fd4\u56de:" + result));
        if (result == null) {
            return null;
        }
        WriteFileInfoResp writeFileInfoResp = (WriteFileInfoResp)JSON.parseObject((String)result, WriteFileInfoResp.class);
        return writeFileInfoResp;
    }

    public static GetLockResp getLock(String sn, String action) {
        String url = cloudSideAddress + getLockPath + "?sn=" + sn + "&action=" + action;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        logger.info((Object)("getLock,\u4e91\u7aef\u8fd4\u56de" + result));
        if (result == null) {
            return null;
        }
        GetLockResp getLockResp = null;
        try {
            getLockResp = (GetLockResp)JSON.parseObject((String)result, GetLockResp.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return getLockResp;
    }

    private static FuncListResp getSwitch(String sn) {
        String url = cloudSideAddress + getSwitchPath + "?sn=" + sn;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        logger.info((Object)("getSwitch,\u4e91\u7aef\u8fd4\u56de" + result));
        if (result == null) {
            return null;
        }
        FuncListResp funcListResp = null;
        try {
            funcListResp = (FuncListResp)JSON.parseObject((String)result, FuncListResp.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return funcListResp;
    }

    public static Map getActionMap() {
        if (Constant.getSn() == null) {
            logger.info((Object)"\u5ba2\u6237\u7aef\u5e8f\u5217\u53f7sn\u4e3a\u7a7a");
            return null;
        }
        FuncListResp funcListResp = CallCloudSide.getSwitch(Constant.getSn());
        if (funcListResp != null && funcListResp.getErrcode() == 0 && funcListResp.getData() != null) {
            try {
                GetSqlPlanFileFactory.getRemoteInstance().setSqlPlanTimeLimit(funcListResp.getData().getSqlplanCostSeconds() * 1000 + "");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            Constant.setFolderId(funcListResp.getData().getFolderId());
            List<FuncListResp.DataBean.FunctionsBean> functionList = funcListResp.getData().getFunctions();
            if (functionList != null && functionList.size() != 0) {
                ConcurrentHashMap<String, ArrayList> actionMap = new ConcurrentHashMap<String, ArrayList>();
                FuncListResp.DataBean.FunctionsBean listBean2 = null;
                for (FuncListResp.DataBean.FunctionsBean listBean2 : functionList) {
                    if (listBean2 == null) continue;
                    String[] splitStrs = listBean2.getCode().toLowerCase().split("\\$");
                    if (splitStrs.length == 2) {
                        ArrayList list;
                        if (actionMap.get(splitStrs[0]) != null) {
                            list = (ArrayList)actionMap.get(splitStrs[0]);
                            list.add(splitStrs[1]);
                            continue;
                        }
                        list = new ArrayList();
                        actionMap.put(splitStrs[0], list);
                        list.add(splitStrs[1]);
                        continue;
                    }
                    logger.warn((Object)("\u76d1\u542c\u7684key\u4e0d\u80fd\u6b63\u786e\u4ee5$\u7b26\u53f7\u5206\u9694" + listBean2.getCode()));
                }
                return actionMap;
            }
        }
        return null;
    }

    static {
        String deploy = System.getProperty("easclient.root");
        String perfLog = deploy + File.separator + "performRecordCli.properties";
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(perfLog));
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        String propVal = prop.getProperty("cloudSideAddress");
        cloudSideAddress = propVal == null ? "http://172.17.2.205:8098/loganalysis/api/" : propVal;
        logger.info((Object)("\u521d\u59cb\u5316\u4e91\u7aef\u5730\u5740\u4e3a :" + cloudSideAddress));
    }
}

