/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.recordSlowReq;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.rpc.recordSlowReq.HttpUtil;
import com.kingdee.bos.rpc.recordSlowReq.UploadCloudUtil;
import com.kingdee.bos.rpc.recordSlowReq.response.CheckFolderResp;
import com.kingdee.bos.rpc.recordSlowReq.response.CloudBaseResp;
import com.kingdee.bos.rpc.recordSlowReq.response.DownLoadFileResp;
import com.kingdee.bos.rpc.recordSlowReq.response.FileListResp;
import com.kingdee.bos.rpc.recordSlowReq.response.NewFolderResp;
import com.kingdee.bos.rpc.recordSlowReq.response.UploadFileResp;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CallKDCloud {
    private static String cloudAddress = null;
    private static final String getFileListPath = "kdrive/user/file/list";
    private static final String fileOperatePath = "kdrive/user/file";
    private static final String fileFolderOperatePath = "kdrive/user/folder";
    private static final String downLoadFilePath = "kdrive/user/file/download/query";
    private static final String checkFolderExistPath = "kdrive/user/folder/existence";
    private static Logger logger = Logger.getLogger(CallKDCloud.class);

    public static void setAddress(String url) {
        cloudAddress = url;
    }

    public static String getAddress() {
        return cloudAddress;
    }

    public static FileListResp getFileList(String accessToken) {
        String url = cloudAddress + getFileListPath + "?access_token=" + accessToken;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        FileListResp fileListResp = (FileListResp)JSON.parseObject((String)result, FileListResp.class);
        return fileListResp;
    }

    public static CloudBaseResp deleteFolder(Integer foldId, String accessToken) {
        String url = cloudAddress + fileFolderOperatePath + "?access_token=" + accessToken + "&folder_id=" + foldId;
        String result = HttpUtil.delete(url, null, 5000, 5000, "UTF-8");
        CloudBaseResp cloudBaseResp = (CloudBaseResp)JSON.parseObject((String)result, CloudBaseResp.class);
        return cloudBaseResp;
    }

    public static NewFolderResp CreateFolder(String foldName, String accessToken) {
        String url = cloudAddress + fileFolderOperatePath + "?access_token=" + accessToken + "&name=" + foldName;
        String result = HttpUtil.post(url, null, 5000, 5000, "UTF-8");
        logger.info((Object)("\u8c03\u7528\u4e91\u76d8\u521b\u5efa\u6587\u4ef6\u5939\uff0c\u4e91\u76d8\u8fd4\u56de:" + result));
        NewFolderResp newFolderResp = (NewFolderResp)JSON.parseObject((String)result, NewFolderResp.class);
        return newFolderResp;
    }

    public static UploadFileResp uploadFile(String url, byte[] bytes, String fileName) {
        logger.info((Object)"\u5f00\u59cb\u8c03\u7528\u4e91\u76d8\u4e0a\u4f20\u6587\u4ef6");
        String result = UploadCloudUtil.uploadFile(url, bytes, fileName);
        logger.info((Object)("\u8c03\u7528\u4e91\u76d8\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e91\u76d8\u8fd4\u56de:" + result));
        UploadFileResp uploadFileResp = (UploadFileResp)JSON.parseObject((String)result, UploadFileResp.class);
        return uploadFileResp;
    }

    public static CloudBaseResp deleteFile(Integer file_id, String accessToken) {
        String url = cloudAddress + fileOperatePath + "?access_token=" + accessToken + "&file_id=" + file_id;
        String result = HttpUtil.delete(url, null, 5000, 5000, "UTF-8");
        CloudBaseResp cloudBaseResp = (CloudBaseResp)JSON.parseObject((String)result, CloudBaseResp.class);
        return cloudBaseResp;
    }

    public static DownLoadFileResp downLoadFile(Integer file_id, String accessToken) {
        String url = cloudAddress + downLoadFilePath + "?access_token=" + accessToken + "&file_id=" + file_id;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        DownLoadFileResp downLoadFileResp = (DownLoadFileResp)JSON.parseObject((String)result, DownLoadFileResp.class);
        return downLoadFileResp;
    }

    public static CheckFolderResp checkFolderExistPath(String folderName, String accessToken) {
        String url = cloudAddress + checkFolderExistPath + "?access_token=" + accessToken + "&name=" + folderName;
        String result = HttpUtil.get(url, null, 5000, 5000, "UTF-8");
        logger.info((Object)("\u8c03\u7528\u4e91\u76d8\u6821\u9a8c\u6587\u4ef6\u5939\u662f\u5426\u5b58\u5728\uff0c\u4e91\u76d8\u8fd4\u56de:" + result));
        CheckFolderResp checkFolderResp = (CheckFolderResp)JSON.parseObject((String)result, CheckFolderResp.class);
        return checkFolderResp;
    }

    static {
        String deploy = System.getProperty("easclient.root");
        String perfLog = deploy + File.separator + "performRecordCli.properties";
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(perfLog));
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        String propVal = prop.getProperty("cloudAddress");
        cloudAddress = propVal == null ? "http://192.168.206.231/api/" : propVal;
        logger.info((Object)("\u521d\u59cb\u5316\u4e91\u76d8\u5730\u5740\u4e3a :" + cloudAddress));
    }
}

