/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.recordSlowReq;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.rpc.recordSlowReq.response.FuncListResp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static Logger logger = Logger.getLogger(HttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokeUrl(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String encoding, HttpMethod method) {
        StringBuilder paramsStr = null;
        if (params != null) {
            paramsStr = new StringBuilder();
            Set entries = params.entrySet();
            for (Map.Entry entry : entries) {
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                paramsStr.append(entry.getKey() + "=" + value + "&");
            }
            if (method != HttpMethod.POST) {
                url = url + "?" + paramsStr.toString();
            }
        }
        URL uUrl = null;
        HttpURLConnection conn = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        try {
            uUrl = new URL(url);
            conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestProperty("content-type", "application/json");
            conn.setRequestMethod(method.toString());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (headers != null && headers.size() > 0) {
                Set<String> headerSet = headers.keySet();
                for (String key : headerSet) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (paramsStr != null && method == HttpMethod.POST) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write(paramsStr.toString());
                out.flush();
            }
            StringBuilder result = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            if (in != null) {
                String line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("url : " + url + "  http\u8c03\u7528\u5f02\u5e38\uff0cex : " + e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static String post(String url, Map params, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, null, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    public static String post(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    public static String get(String url, Map params, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, null, connectTimeout, readTimeout, charset, HttpMethod.GET);
    }

    public static String get(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.GET);
    }

    public static String put(String url, Map params, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, null, connectTimeout, readTimeout, charset, HttpMethod.PUT);
    }

    public static String put(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.PUT);
    }

    public static String delete(String url, Map params, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, null, connectTimeout, readTimeout, charset, HttpMethod.DELETE);
    }

    public static String delete(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.DELETE);
    }

    public static String head(String url, Map params, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, null, connectTimeout, readTimeout, charset, HttpMethod.HEAD);
    }

    public static String head(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) {
        return HttpUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.HEAD);
    }

    public static String request(String httpUrl, Map<String, String> header, String httpArg, boolean isGet, boolean isContentTypeJSON) {
        String result = null;
        StringBuffer sbf = new StringBuffer();
        HttpURLConnection connection = null;
        FilterOutputStream out = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            if (isGet) {
                connection.setRequestMethod("GET");
            } else {
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                if (isContentTypeJSON) {
                    connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                }
                out = new DataOutputStream(connection.getOutputStream());
                ((DataOutputStream)out).writeBytes(httpArg);
                ((DataOutputStream)out).flush();
            }
            if (header != null && header.size() > 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("HTTP\u8fde\u63a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static String jsonRequest(String httpUrl, String jsonStr) {
        return HttpUtil.request(httpUrl, null, jsonStr, false, true);
    }

    public static void main(String[] args) {
        String s = HttpUtil.get("http://172.19.77.143:8080/loganalysis/api/getLogSwitch?sn=abcd", null, 3000, 3000, "UTF-8");
        FuncListResp funcListResp = (FuncListResp)JSON.parseObject((String)s, FuncListResp.class);
        System.out.println(s);
    }

    private static enum HttpMethod {
        POST,
        DELETE,
        GET,
        PUT,
        HEAD;

    }
}

